package com.ximai.mes.md.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdSaleOrderGroupMapper;
import com.ximai.mes.md.domain.MdSaleOrderGroup;
import com.ximai.mes.md.service.IMdSaleOrderGroupService;

/**
 * 销售订单销售小组Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@Service
public class MdSaleOrderGroupServiceImpl implements IMdSaleOrderGroupService
{
    @Autowired
    private MdSaleOrderGroupMapper mdSaleOrderGroupMapper;

    /**
     * 查询销售订单销售小组
     *
     * @param id 销售订单销售小组主键
     * @return 销售订单销售小组
     */
    @Override
    public MdSaleOrderGroup selectMdSaleOrderGroupById(Long id)
    {
        return mdSaleOrderGroupMapper.selectMdSaleOrderGroupById(id);
    }

    /**
     * 查询销售订单销售小组列表
     *
     * @param mdSaleOrderGroup 销售订单销售小组
     * @return 销售订单销售小组
     */
    @Override
    public List<MdSaleOrderGroup> selectMdSaleOrderGroupList(MdSaleOrderGroup mdSaleOrderGroup)
    {
        return mdSaleOrderGroupMapper.selectMdSaleOrderGroupList(mdSaleOrderGroup);
    }

    /**
     * 新增销售订单销售小组
     *
     * @param mdSaleOrderGroup 销售订单销售小组
     * @return 结果
     */
    @Override
    public int insertMdSaleOrderGroup(MdSaleOrderGroup mdSaleOrderGroup)
    {
        return mdSaleOrderGroupMapper.insertMdSaleOrderGroup(mdSaleOrderGroup);
    }

    /**
     * 修改销售订单销售小组
     *
     * @param mdSaleOrderGroup 销售订单销售小组
     * @return 结果
     */
    @Override
    public int updateMdSaleOrderGroup(MdSaleOrderGroup mdSaleOrderGroup)
    {
        return mdSaleOrderGroupMapper.updateMdSaleOrderGroup(mdSaleOrderGroup);
    }

    /**
     * 批量删除销售订单销售小组
     *
     * @param ids 需要删除的销售订单销售小组主键
     * @return 结果
     */
    @Override
    public int deleteMdSaleOrderGroupByIds(Long[] ids)
    {
        return mdSaleOrderGroupMapper.deleteMdSaleOrderGroupByIds(ids);
    }

    /**
     * 删除销售订单销售小组信息
     *
     * @param id 销售订单销售小组主键
     * @return 结果
     */
    @Override
    public int deleteMdSaleOrderGroupById(Long id)
    {
        return mdSaleOrderGroupMapper.deleteMdSaleOrderGroupById(id);
    }
}
