package com.ximai.mes.md.service.impl;

import java.util.List;
import com.ximai.common.utils.data.DateUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdClientUrgeEmailMapper;
import com.ximai.mes.md.domain.MdClientUrgeEmail;
import com.ximai.mes.md.service.IMdClientUrgeEmailService;

/**
 * 催货款通知邮箱Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-19
 */
@Service
public class MdClientUrgeEmailServiceImpl implements IMdClientUrgeEmailService
{
    @Autowired
    private MdClientUrgeEmailMapper mdClientUrgeEmailMapper;

    /**
     * 查询催货款通知邮箱
     *
     * @param id 催货款通知邮箱主键
     * @return 催货款通知邮箱
     */
    @Override
    public MdClientUrgeEmail selectMdClientUrgeEmailById(String id)
    {
        return mdClientUrgeEmailMapper.selectMdClientUrgeEmailById(id);
    }

    /**
     * 查询催货款通知邮箱列表
     *
     * @param mdClientUrgeEmail 催货款通知邮箱
     * @return 催货款通知邮箱
     */
    @Override
    public List<MdClientUrgeEmail> selectMdClientUrgeEmailList(MdClientUrgeEmail mdClientUrgeEmail)
    {
        return mdClientUrgeEmailMapper.selectMdClientUrgeEmailList(mdClientUrgeEmail);
    }

    /**
     * 新增催货款通知邮箱
     *
     * @param mdClientUrgeEmail 催货款通知邮箱
     * @return 结果
     */
    @Override
    public int insertMdClientUrgeEmail(MdClientUrgeEmail mdClientUrgeEmail)
    {
        mdClientUrgeEmail.setCreateTime(DateUtils.getNowDate());
        return mdClientUrgeEmailMapper.insertMdClientUrgeEmail(mdClientUrgeEmail);
    }

    /**
     * 修改催货款通知邮箱
     *
     * @param mdClientUrgeEmail 催货款通知邮箱
     * @return 结果
     */
    @Override
    public int updateMdClientUrgeEmail(MdClientUrgeEmail mdClientUrgeEmail)
    {
        mdClientUrgeEmail.setUpdateTime(DateUtils.getNowDate());
        return mdClientUrgeEmailMapper.updateMdClientUrgeEmail(mdClientUrgeEmail);
    }

    /**
     * 批量删除催货款通知邮箱
     *
     * @param ids 需要删除的催货款通知邮箱主键
     * @return 结果
     */
    @Override
    public int deleteMdClientUrgeEmailByIds(String[] ids)
    {
        return mdClientUrgeEmailMapper.deleteMdClientUrgeEmailByIds(ids);
    }

    /**
     * 删除催货款通知邮箱信息
     *
     * @param id 催货款通知邮箱主键
     * @return 结果
     */
    @Override
    public int deleteMdClientUrgeEmailById(String id)
    {
        return mdClientUrgeEmailMapper.deleteMdClientUrgeEmailById(id);
    }
}
