package com.ximai.mes.md.service;

import java.util.List;
import com.ximai.mes.md.domain.MdVehicle;
import org.springframework.web.multipart.MultipartFile;

/**
 * 车辆列表Service接口
 *
 * @author generator
 * @date 2024-01-25
 */
public interface IMdVehicleService
{
    /**
     * 查询车辆列表
     *
     * @param vehicleId 车辆列表主键
     * @return 车辆列表
     */
    public MdVehicle selectMdVehicleByVehicleId(Long vehicleId);

    /**
     * 查询车辆列表列表
     *
     * @param mdVehicle 车辆列表
     * @return 车辆列表集合
     */
    public List<MdVehicle> selectMdVehicleList(MdVehicle mdVehicle);

    /**
     * 新增车辆列表
     *
     * @param mdVehicle 车辆列表
     * @return 结果
     */
    public int insertMdVehicle(MdVehicle mdVehicle);

    /**
     * 修改车辆列表
     *
     * @param mdVehicle 车辆列表
     * @return 结果
     */
    public int updateMdVehicle(MdVehicle mdVehicle);

    /**
     * 批量删除车辆列表
     *
     * @param vehicleIds 需要删除的车辆列表主键集合
     * @return 结果
     */
    public int deleteMdVehicleByVehicleIds(Long[] vehicleIds);

    /**
     * 删除车辆列表信息
     *
     * @param vehicleId 车辆列表主键
     * @return 结果
     */
    public int deleteMdVehicleByVehicleId(Long vehicleId);

    /**
     * 导入车辆列表信息
     * @param file
     * @param isUpdateSupport
     * @param operName
     * @return
     */
    public void importVehicle(MultipartFile file, Boolean isUpdateSupport, String operName) throws Exception;
}
