package com.ximai.mes.md.service;

import java.util.List;
import com.ximai.mes.md.domain.MdSalesShipmentPoint;

/**
 * 销售订单装运点Service接口
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
public interface IMdSalesShipmentPointService
{
    /**
     * 查询销售订单装运点
     *
     * @param id 销售订单装运点主键
     * @return 销售订单装运点
     */
    public MdSalesShipmentPoint selectMdSalesShipmentPointById(String id);

    /**
     * 查询销售订单装运点列表
     *
     * @param mdSalesShipmentPoint 销售订单装运点
     * @return 销售订单装运点集合
     */
    public List<MdSalesShipmentPoint> selectMdSalesShipmentPointList(MdSalesShipmentPoint mdSalesShipmentPoint);

    /**
     * 新增销售订单装运点
     *
     * @param mdSalesShipmentPoint 销售订单装运点
     * @return 结果
     */
    public int insertMdSalesShipmentPoint(MdSalesShipmentPoint mdSalesShipmentPoint);

    /**
     * 修改销售订单装运点
     *
     * @param mdSalesShipmentPoint 销售订单装运点
     * @return 结果
     */
    public int updateMdSalesShipmentPoint(MdSalesShipmentPoint mdSalesShipmentPoint);

    /**
     * 批量删除销售订单装运点
     *
     * @param ids 需要删除的销售订单装运点主键集合
     * @return 结果
     */
    public int deleteMdSalesShipmentPointByIds(String[] ids);

    /**
     * 删除销售订单装运点信息
     *
     * @param id 销售订单装运点主键
     * @return 结果
     */
    public int deleteMdSalesShipmentPointById(String id);
}
