package com.ximai.mes.md.mapper;

import java.util.List;
import com.ximai.mes.md.domain.MdProductCustomer;

/**
 * 产品客户配置Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
public interface MdProductCustomerMapper
{
    /**
     * 查询产品客户配置
     *
     * @param productCustomerId 产品客户配置主键
     * @return 产品客户配置
     */
    public MdProductCustomer selectMdProductCustomerByProductCustomerId(Long productCustomerId);

    /**
     * 查询产品客户配置列表
     *
     * @param mdProductCustomer 产品客户配置
     * @return 产品客户配置集合
     */
    public List<MdProductCustomer> selectMdProductCustomerList(MdProductCustomer mdProductCustomer);

    /**
     * 新增产品客户配置
     *
     * @param mdProductCustomer 产品客户配置
     * @return 结果
     */
    public int insertMdProductCustomer(MdProductCustomer mdProductCustomer);

    /**
     * 修改产品客户配置
     *
     * @param mdProductCustomer 产品客户配置
     * @return 结果
     */
    public int updateMdProductCustomer(MdProductCustomer mdProductCustomer);

    /**
     * 删除产品客户配置
     *
     * @param productCustomerId 产品客户配置主键
     * @return 结果
     */
    public int deleteMdProductCustomerByProductCustomerId(Long productCustomerId);

    /**
     * 批量删除产品客户配置
     *
     * @param productCustomerIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteMdProductCustomerByProductCustomerIds(Long[] productCustomerIds);
}
