package com.ximai.mes.md.mapper;

import com.ximai.mes.md.domain.MdFaceColor;
import com.ximai.mes.md.vo.MdFaceColorVo;

import java.util.List;

/**
* @author 16508
* @description 针对表【md_face_color(产品版面颜色)】的数据库操作Mapper
* @createDate 2024-01-15 19:08:20
* @Entity com.ximai.mes.md.domain.MdFaceColor
*/
public interface MdFaceColorMapper {
    /**
     * 查询产品颜色
     * @param mdFaceColorId
     * @return
     */
    public MdFaceColorVo selectMdFaceColorByMdFaceColorId(Long mdFaceColorId);

    /**
     * 查询产品颜色列表
     * @param faceColor
     * @return
     */
    public List<MdFaceColorVo> selectMdFaceColorList(MdFaceColor faceColor);

    /**
     * 新增产品颜色关系
     * @param mdFaceColor
     * @return
     */
    public int insertMdFaceColor(MdFaceColor mdFaceColor);

    /**
     * 修改产品颜色关系
     * @param mdFaceColor
     * @return
     */
    public int updateMdFaceColor(MdFaceColor mdFaceColor);

    /**
     * 批量删除产品颜色
     * @param mdFaceColorIds
     * @return
     */
    public int deleteMdFaceColorByMdFaceColorIds(Long[] mdFaceColorIds);

    public int deleteMdFaceColorByMdFaceColorId(Long mdFaceColorId);


    String checkMdFaceColorUnique(MdFaceColor mdFaceColor);
}




