package com.ximai.mes.md.domain;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 供应商对象 md_vendor
 *
 * @date 2022-05-06
 */
@Data
public class MdVendor extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 供应商ID */
    private Long vendorId;

    /** 供应商编码 */
    @Excel(name = "供应商编码")
    private String vendorCode;

    /** 供应商名称 */
    @Excel(name = "供应商名称")
    private String vendorName;

    /** 供应商简称 */
    @Excel(name = "供应商简称")
    private String vendorNick;

    /** 供应商英文名称 */
    @Excel(name = "供应商英文名称")
    private String vendorEn;

    /** 供应商简介 */
    @Excel(name = "供应商简介")
    private String vendorDes;

    /** 供应商LOGO地址 */
    @Excel(name = "供应商LOGO地址")
    private String vendorLogo;

    /** 供应商等级 */
    @Excel(name = "供应商等级")
    private String vendorLevel;

    /** 供应商评分 */
    @Excel(name = "供应商评分")
    private Long vendorScore;

    /** 供应商地址 */
    @Excel(name = "供应商地址")
    private String address;

    /** 供应商官网地址 */
    @Excel(name = "供应商官网地址")
    private String website;

    /** 供应商邮箱地址 */
    @Excel(name = "供应商邮箱地址")
    private String email;

    /** 供应商电话 */
    @Excel(name = "供应商电话")
    private String tel;

    /** 联系人1 */
    @Excel(name = "联系人1")
    private String contact1;

    /** 联系人1-电话 */
    @Excel(name = "联系人1-电话")
    private String contact1Tel;

    /** 联系人1-邮箱 */
    @Excel(name = "联系人1-邮箱")
    private String contact1Email;

    /** 联系人2 */
    @Excel(name = "联系人2")
    private String contact2;

    /** 联系人2-电话 */
    @Excel(name = "联系人2-电话")
    private String contact2Tel;

    /** 联系人2-邮箱 */
    @Excel(name = "联系人2-邮箱")
    private String contact2Email;

    /** 统一社会信用代码 */
    @Excel(name = "统一社会信用代码")
    private String creditCode;

    /** 是否启用 */
    @Excel(name = "是否启用")
    private String enableFlag;

    @ApiModelProperty("交易币种")
    private String currency;

    /**
     * 1.二联式、2.三联式、3.二联式收银机发票、4.三联式收银机发票、5.电子计算机发票、6.免用统一发票、S.可抵扣专用发票、B.普通发票、T.运输发票、N.不可抵扣专用发票 A.农产品收购凭证、G.海关代征完税凭证、W.废旧物资收购凭证、Z.其他 //901025 S06-9009036 MODI A~Z   //8
     */
    @ApiModelProperty("发票种类")
    private String invoiceType;

    /** 预留字段1 */
    private String attr1;

    /** 预留字段2 */
    private String attr2;

    /** 预留字段3 */
    private Integer attr3;

    /** 预留字段4 */
    private Integer attr4;

}
