package com.ximai.mes.md.domain;

import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 产品特性名称对象 md_item_spec
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
public class MdProductSpec extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 产品特性id */
    private Long itemSpecId;

    /** 产品id */
    @Excel(name = "产品id")
    private Long itemId;

    /** 产品特性名称 */
    @Excel(name = "产品特性名称")
    private String spec;

    public void setItemSpecId(Long itemSpecId)
    {
        this.itemSpecId = itemSpecId;
    }

    public Long getItemSpecId()
    {
        return itemSpecId;
    }
    public void setItemId(Long itemId)
    {
        this.itemId = itemId;
    }

    public Long getItemId()
    {
        return itemId;
    }
    public void setSpec(String spec)
    {
        this.spec = spec;
    }

    public String getSpec()
    {
        return spec;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("itemSpecId", getItemSpecId())
            .append("itemId", getItemId())
            .append("spec", getSpec())
            .toString();
    }
}
