package com.ximai.mes.md.domain;

import java.math.BigDecimal;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 产品打样排版参数配置对象 md_product_published_conf
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
public class MdProductPublishedConf extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** 产品ID */
    @Excel(name = "产品ID")
    private Long itemId;

    /** 模数 */
    @Excel(name = "模数")
    private Long modulus;

    /** 行数 */
    @Excel(name = "行数")
    private Long rowNum;

    /** 列数 */
    @Excel(name = "列数")
    private Long columnNum;

    /** 搭版数 */
    @Excel(name = "搭版数")
    private BigDecimal contactNum;

    /** 行双刀位(单位mm) */
    @Excel(name = "行双刀位(单位mm)")
    private BigDecimal rowDoubleBlade;

    /** 列双刀位(单位mm) */
    @Excel(name = "列双刀位(单位mm)")
    private BigDecimal columnDoubleBlade;

    /** 派工倍数 */
    @Excel(name = "派工倍数")
    private BigDecimal dispatchMultiple;

    /** 印张长度(单位cm) */
    @Excel(name = "印张长度(单位cm)")
    private BigDecimal sheetLength;

    /** 印张宽度(单位cm) */
    @Excel(name = "印张宽度(单位cm)")
    private BigDecimal sheetWidth;

    public void setItemId(Long itemId)
    {
        this.itemId = itemId;
    }

    public Long getItemId()
    {
        return itemId;
    }
    public void setModulus(Long modulus)
    {
        this.modulus = modulus;
    }

    public Long getModulus()
    {
        return modulus;
    }
    public void setRowNum(Long rowNum)
    {
        this.rowNum = rowNum;
    }

    public Long getRowNum()
    {
        return rowNum;
    }
    public void setColumnNum(Long columnNum)
    {
        this.columnNum = columnNum;
    }

    public Long getColumnNum()
    {
        return columnNum;
    }
    public void setContactNum(BigDecimal contactNum)
    {
        this.contactNum = contactNum;
    }

    public BigDecimal getContactNum()
    {
        return contactNum;
    }
    public void setRowDoubleBlade(BigDecimal rowDoubleBlade)
    {
        this.rowDoubleBlade = rowDoubleBlade;
    }

    public BigDecimal getRowDoubleBlade()
    {
        return rowDoubleBlade;
    }
    public void setColumnDoubleBlade(BigDecimal columnDoubleBlade)
    {
        this.columnDoubleBlade = columnDoubleBlade;
    }

    public BigDecimal getColumnDoubleBlade()
    {
        return columnDoubleBlade;
    }
    public void setDispatchMultiple(BigDecimal dispatchMultiple)
    {
        this.dispatchMultiple = dispatchMultiple;
    }

    public BigDecimal getDispatchMultiple()
    {
        return dispatchMultiple;
    }
    public void setSheetLength(BigDecimal sheetLength)
    {
        this.sheetLength = sheetLength;
    }

    public BigDecimal getSheetLength()
    {
        return sheetLength;
    }
    public void setSheetWidth(BigDecimal sheetWidth)
    {
        this.sheetWidth = sheetWidth;
    }

    public BigDecimal getSheetWidth()
    {
        return sheetWidth;
    }

    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("itemId", getItemId())
            .append("modulus", getModulus())
            .append("rowNum", getRowNum())
            .append("columnNum", getColumnNum())
            .append("contactNum", getContactNum())
            .append("rowDoubleBlade", getRowDoubleBlade())
            .append("columnDoubleBlade", getColumnDoubleBlade())
            .append("dispatchMultiple", getDispatchMultiple())
            .append("sheetLength", getSheetLength())
            .append("sheetWidth", getSheetWidth())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
