package com.ximai.mes.md.domain;

import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.Getter;
import lombok.Setter;
import lombok.ToString;

/**
 * 客户对象 md_client
 *
 * @author yinjinlu
 * @date 2024-01-19
 */
@Getter
@Setter
@ToString
public class MdClient extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * 客户ID
     */
    private Long clientId;

    /**
     * 客户编码
     */
    @Excel(name = "客户编码")
    private String clientCode;

    /**
     * sap客户编码
     */
    @Excel(name = "sap客户编码")
    private String sapClientCode;

    /**
     * 客户名称
     */
    @Excel(name = "客户名称")
    private String clientName;

    /**
     * 客户简称
     */
    @Excel(name = "客户简称")
    private String clientNick;

    /**
     * 客户英文名称
     */
    @Excel(name = "客户英文名称")
    private String clientEn;

    /**
     * 英文名简称
     */
    @Excel(name = "英文名简称")
    private String clientEnAbbr;

    /**
     * 客户等级
     */
    @Excel(name = "客户等级")
    private Long clientLevel;

    /**
     * 做账难度等级
     */
    @Excel(name = "做账难度等级")
    private Long billLevel;

    /**
     * 开票地址
     */
    @Excel(name = "开票地址")
    private String invoiceAddr;

    /**
     * 客户送货地址
     */
    @Excel(name = "客户送货地址")
    private String address;

    /**
     * 所属地区
     */
    @Excel(name = "所属地区")
    private String region;

    /**
     * 国家
     */
    @Excel(name = "国家")
    private String country;

    /**
     * 城市
     */
    @Excel(name = "城市")
    private String city;

    /**
     * 地区
     */
    @Excel(name = "地区")
    private String area;

    /**
     * 语言
     */
    @Excel(name = "语言")
    private String lang;

    /**
     * 邮政编码
     */
    @Excel(name = "邮政编码")
    private String postcode;

    /**
     * 电话号码
     */
    @Excel(name = "电话号码")
    private String tel;

    /**
     * 移动电话
     */
    @Excel(name = "移动电话")
    private String phone;

    /**
     * email
     */
    @Excel(name = "email")
    private String email;

    /**
     * 要求用客户系统货单
     */
    @Excel(name = "要求用客户系统货单")
    private String isClientWaybill;

    /**
     * 盖章方式
     */
    @Excel(name = "盖章方式")
    private String stampMode;

    /**
     * 请款联
     */
    @Excel(name = "请款联")
    private String requisition;

    /**
     * 客户联
     */
    @Excel(name = "客户联")
    private String clientForm;

    /**
     * 订单要求
     */
    @Excel(name = "订单要求")
    private String orderRequest;

    /**
     * 验收单要求
     */
    @Excel(name = "验收单要求")
    private String receiptRequest;

    /**
     * 客户系统验收要求
     */
    @Excel(name = "客户系统验收要求")
    private String clientCheckRequest;

    /**
     * 要求签回货单
     */
    @Excel(name = "要求签回货单")
    private String requestSignReceipt;

    /**
     * 货单是否打印送货日期
     */
    @Excel(name = "货单是否打印送货日期")
    private String isPrintDate;

    /**
     * 不开发票
     */
    @Excel(name = "不开发票")
    private String noInvoice;

    /**
     * 请款要求
     */
    @Excel(name = "请款要求")
    private String paymentRequest;

    /**
     * 客户工作时间
     */
    @Excel(name = "客户工作时间")
    private String clientWorkTime;

    /**
     * 收货方签字要求
     */
    @Excel(name = "收货方签字要求")
    private String signRequest;

    /**
     * 货单打印要求
     */
    @Excel(name = "货单打印要求")
    private String billPrintRequest;

    /**
     * 所属集团
     */
    @Excel(name = "所属集团")
    private String membershipGroup;

    /**
     * 产品检验报告类型
     */
    @Excel(name = "产品检验报告类型")
    private String qcReportType;

    /**
     * 货单签回方式
     */
    @Excel(name = "货单签回方式")
    private String receiptSigningMethod;

    /**
     * 出货方式
     */
    @Excel(name = "出货方式")
    private String shippingMethod;

    /**
     * 线路
     */
    @Excel(name = "线路")
    private String path;

    /**
     * 送货单打印默认设置
     */
    @Excel(name = "送货单打印默认设置")
    private String billPrintSetting;

    /**
     * 送货单统计异常期限
     */
    @Excel(name = "送货单统计异常期限")
    private String billExceptionDeadline;

    /**
     * 生产发货方式
     */
    @Excel(name = "生产发货方式")
    private String sendMode;

    /**
     * 月结方式（金库查询结算方式）
     */
    @Excel(name = "月结方式", readConverterExp = "金=库查询结算方式")
    private String settleMode;

    /**
     * 请款期限
     */
    @Excel(name = "请款期限")
    private String paymentDeadline;

    /**
     * 做账截止日
     */
    @Excel(name = "做账截止日")
    private String accountingDeadline;

    /**
     * 客户收账截止日
     */
    @Excel(name = "客户收账截止日")
    private String collectionDeadline;

    /**
     * 订单统计异常期限
     */
    @Excel(name = "订单统计异常期限")
    private String orderExceptionDeadline;

    /**
     * 扣款百分比
     */
    @Excel(name = "扣款百分比")
    private String deductionPercent;

    /**
     * 金额小数位数
     */
    @Excel(name = "金额小数位数")
    private String amountDecimal;

    /**
     * 公司法人
     */
    @Excel(name = "公司法人")
    private String legalPerson;

    /**
     * 工商注册号
     */
    @Excel(name = "工商注册号")
    private String licenseNo;

    /**
     * 国税注册号
     */
    @Excel(name = "国税注册号")
    private String taxNo;

    /**
     * 订单性质
     */
    @Excel(name = "订单性质")
    private String orderKind;

    /**
     * 是否启用
     */
    @Excel(name = "是否启用")
    private String enableFlag;

}
