package com.ximai.mes.md.domain;

import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;

/**
 * 【请填写功能名称】对象 md_brand_visit
 *
 * @author yinjinlu
 * @date 2024-01-16
 */
public class MdBrandVisit extends BaseEntity
{
    private static final long serialVersionUID = 1L;

    /** id */
    private Long brandVisitId;

    /** 品牌id */
    @Excel(name = "品牌id")
    private Long brandId;


    /** 品牌编码*/
    @Excel(name = "品牌编码")
    private String brandCode;


    /** 品牌名称*/
    @Excel(name = "品牌名称")
    private String brandName;

    /** 访问客户 */
    @Excel(name = "访问客户")
    private String contactName;

    /** 访问人 */
    @Excel(name = "访问人")
    private String visitPerson;

    /** 拜访时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "拜访时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date visitTime;

    /** 拜访纪要 */
    @Excel(name = "拜访纪要")
    private String visitSummary;

    /** 是否启用 */
    @Excel(name = "是否启用")
    private String enableFlag;


    public String getBrandCode() {
        return brandCode;
    }

    public void setBrandCode(String brandCode) {
        this.brandCode = brandCode;
    }
    public void setBrandVisitId(Long brandVisitId)
    {
        this.brandVisitId = brandVisitId;
    }

    public Long getBrandVisitId()
    {
        return brandVisitId;
    }
    public void setBrandId(Long brandId)
    {
        this.brandId = brandId;
    }

    public Long getBrandId()
    {
        return brandId;
    }
    public void setContactName(String contactName)
    {
        this.contactName = contactName;
    }

    public String getContactName()
    {
        return contactName;
    }
    public void setVisitPerson(String visitPerson)
    {
        this.visitPerson = visitPerson;
    }

    public String getVisitPerson()
    {
        return visitPerson;
    }
    public void setVisitTime(Date visitTime)
    {
        this.visitTime = visitTime;
    }

    public Date getVisitTime()
    {
        return visitTime;
    }
    public void setVisitSummary(String visitSummary)
    {
        this.visitSummary = visitSummary;
    }

    public String getVisitSummary()
    {
        return visitSummary;
    }
    public void setEnableFlag(String enableFlag)
    {
        this.enableFlag = enableFlag;
    }

    public String getEnableFlag()
    {
        return enableFlag;
    }

    public String getBrandName() {
        return brandName;
    }

    public void setBrandName(String brandName) {
        this.brandName = brandName;
    }
    @Override
    public String toString() {
        return new ToStringBuilder(this,ToStringStyle.MULTI_LINE_STYLE)
            .append("brandVisitId", getBrandVisitId())
            .append("brandId", getBrandId())
                .append("brandCode", getBrandCode())
                .append("brandName", getBrandName())
            .append("contactName", getContactName())
            .append("visitPerson", getVisitPerson())
            .append("visitTime", getVisitTime())
            .append("visitSummary", getVisitSummary())
            .append("enableFlag", getEnableFlag())
            .append("remark", getRemark())
            .append("createBy", getCreateBy())
            .append("createTime", getCreateTime())
            .append("updateBy", getUpdateBy())
            .append("updateTime", getUpdateTime())
            .toString();
    }
}
