package com.ximai.mes.md.controller;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdProductCustomer;
import com.ximai.mes.md.service.IMdProductCustomerService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 产品客户配置Controller
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
@RestController
@RequestMapping("/md/customer")
public class MdProductCustomerController extends BaseController
{
    @Autowired
    private IMdProductCustomerService mdProductCustomerService;

    /**
     * 查询产品客户配置列表
     */
    @PreAuthorize("@ss.hasPermi('md:customer:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdProductCustomer mdProductCustomer)
    {
        startPage();
        List<MdProductCustomer> list = mdProductCustomerService.selectMdProductCustomerList(mdProductCustomer);
        return getDataTable(list);
    }

    /**
     * 获取产品客户配置详细信息
     */
    @PreAuthorize("@ss.hasPermi('md:customer:query')")
    @GetMapping(value = "/{productCustomerId}")
    public AjaxResult getInfo(@PathVariable("productCustomerId") Long productCustomerId)
    {
        return AjaxResult.success(mdProductCustomerService.selectMdProductCustomerByProductCustomerId(productCustomerId));
    }

    /**
     * 新增产品客户配置
     */
    @PreAuthorize("@ss.hasPermi('md:customer:add')")
    @Log(title = "产品客户配置", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdProductCustomer mdProductCustomer)
    {
        return toAjax(mdProductCustomerService.insertMdProductCustomer(mdProductCustomer));
    }

    /**
     * 修改产品客户配置
     */
    @PreAuthorize("@ss.hasPermi('md:customer:edit')")
    @Log(title = "产品客户配置", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdProductCustomer mdProductCustomer)
    {
        return toAjax(mdProductCustomerService.updateMdProductCustomer(mdProductCustomer));
    }

    /**
     * 删除产品客户配置
     */
    @PreAuthorize("@ss.hasPermi('md:customer:remove')")
    @Log(title = "产品客户配置", businessType = BusinessType.DELETE)
	@DeleteMapping("/{productCustomerIds}")
    public AjaxResult remove(@PathVariable Long[] productCustomerIds)
    {
        return toAjax(mdProductCustomerService.deleteMdProductCustomerByProductCustomerIds(productCustomerIds));
    }
}
