package com.ximai.mes.md.controller;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.md.domain.MdClientContact;
import com.ximai.mes.md.service.IMdClientContactService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.util.List;

/**
 * 客户系人Controller
 *
 * @author yinjinlu
 * @date 2024-01-19
 */
@RestController
@RequestMapping("/md/clientContact")
public class MdClientContactController extends BaseController {
    @Autowired
    private IMdClientContactService mdClientContactService;

    /**
     * 查询客户联系人列表
     */
//    @PreAuthorize("@ss.hasPermi('md:clientContact:list')")
    @GetMapping("/list")
    public TableDataInfo list(MdClientContact mdClientContact) {
        startPage();
        List<MdClientContact> list = mdClientContactService.selectMdClientContactList(mdClientContact);
        return getDataTable(list);
    }
    /**
     * 获取客户联系人详细信息
     */
//    @PreAuthorize("@ss.hasPermi('md:clientContact:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") String id) {
        return AjaxResult.success(mdClientContactService.selectMdClientContactById(id));
    }

    /**
     * 新增客户联系人
     */
//    @PreAuthorize("@ss.hasPermi('md:clientContact:add')")
    @Log(title = "客户联系人", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody MdClientContact mdClientContact) {
        return toAjax(mdClientContactService.insertMdClientContact(mdClientContact));
    }

    /**
     * 修改客户联系人
     */
//    @PreAuthorize("@ss.hasPermi('md:clientContact:edit')")
    @Log(title = "客户联系人", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody MdClientContact mdClientContact) {
        return toAjax(mdClientContactService.updateMdClientContact(mdClientContact));
    }

    /**
     * 删除客户系人
     */
//    @PreAuthorize("@ss.hasPermi('md:clientContact:remove')")
    @Log(title = "客户联系人", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable String[] ids) {
        return toAjax(mdClientContactService.deleteMdClientContactByIds(ids));
    }
}
