package com.ximai.mes.dv.service.impl.dvBrandQuotation;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.mes.dv.domain.devBrandQuotation.*;
import com.ximai.mes.dv.domain.vo.DevBrandQuotationProcessQcindexVo;
import com.ximai.mes.dv.domain.vo.DevBrandQuotationProcessToolVo;
import com.ximai.mes.dv.domain.vo.DvBrandQuotationProcessVo;
import com.ximai.mes.dv.domain.vo.DvBrandQuotationVo;
import com.ximai.mes.dv.mapper.devBrandQuotation.*;
import com.ximai.mes.dv.service.devBrandQuotation.IDevBrandQuotationProcessQcindexService;
import com.ximai.mes.dv.service.devBrandQuotation.IDevBrandQuotationProcessToolService;
import com.ximai.mes.dv.service.devBrandQuotation.IDvBrandQuotationService;


import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import static com.ximai.common.utils.SecurityUtils.getUsername;


/**
 * 【请填写功能名称】Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-25
 */
@Service
public class DvBrandQuotationServiceImpl implements IDvBrandQuotationService
{
    @Autowired
    private DvBrandQuotationMapper devBrandQuotationMapper;

    @Autowired
    private DvBrandQuotationBomMapper DvBrandQuotationBomMapper;

    @Autowired
    private DvBrandQuotationProcessMapper dvBrandQuotationProcessMapper;

    @Autowired
    private DvBrandQuotationProcessItemMapper dvBrandQuotationProcessItemMapper;

    @Autowired
    private DevBrandQuotationProcessToolMapper devBrandQuotationProcessToolMapper;
    @Autowired
    private DevBrandQuotationProcessQcindexMapper devBrandQuotationProcessQcindexMapper;
    @Autowired
    private IDevBrandQuotationProcessToolService devBrandQuotationProcessToolService;
    @Autowired
    private IDevBrandQuotationProcessQcindexService devBrandQuotationProcessQcindexService;

    /**
     * 查询【请填写功能名称】
     *
     * @param brandQuotationId 【请填写功能名称】主键
     * @return 【请填写功能名称】
     */
    @Override
    public DvBrandQuotationVo selectDevBrandQuotationByBrandQuotationId(Long brandQuotationId)
    {
        DvBrandQuotation dvBrandQuotation = devBrandQuotationMapper.selectDevBrandQuotationByBrandQuotationId(brandQuotationId);
        List<DvBrandQuotationBom> dvBrandQuotationBomList = DvBrandQuotationBomMapper.seletDvBrandQuotationBomBybrandQuotationId(brandQuotationId);
        List<DvBrandQuotationProcessVo> dvBrandQuotationProcessList = dvBrandQuotationProcessMapper.selectDvBrandQuotationProcessBybrandQuotationId(brandQuotationId);

        for (DvBrandQuotationProcessVo dvbrandQuotationProcess : dvBrandQuotationProcessList) {
            // 根据记录id获取工序明细
            List<DvBrandQuotationProcessItem> dvBrandQuotationProcessItemList = dvBrandQuotationProcessItemMapper.selectProWorkOrderProcessItemByWorkorderProcessId(dvbrandQuotationProcess.getBrandQuotationProcessId());
            dvbrandQuotationProcess.setProcessItemList(dvBrandQuotationProcessItemList);
        }

        DvBrandQuotationVo dvBrandQuotationVo = new DvBrandQuotationVo();
        BeanUtils.copyProperties(dvBrandQuotation,dvBrandQuotationVo);
        dvBrandQuotationVo.setBomList(dvBrandQuotationBomList);
        dvBrandQuotationVo.setProcessList(dvBrandQuotationProcessList);

        //查询工装量具
        DevBrandQuotationProcessTool toolQuery = new DevBrandQuotationProcessTool();
        toolQuery.setBrandQuotationId(dvBrandQuotation.getBrandQuotationId());

        List<DevBrandQuotationProcessToolVo> toolList = devBrandQuotationProcessToolService.selectDevBrandQuotationProcessToolVoList(toolQuery);
        Map<Long, List<DevBrandQuotationProcessToolVo>> toolMap = toolList.stream().collect(Collectors.groupingBy(s->s.getBrandQuotationProcessId()));
        //查询检验项
        DevBrandQuotationProcessQcindex qcindexQuery = new DevBrandQuotationProcessQcindex();
        toolQuery.setBrandQuotationId(dvBrandQuotation.getBrandQuotationId());
        List<DevBrandQuotationProcessQcindexVo> qcindexList = devBrandQuotationProcessQcindexService.selectDevBrandQuotationProcessQcindexVoList(qcindexQuery);
        Map<Long, List<DevBrandQuotationProcessQcindexVo>> qcindexMap = qcindexList.stream().collect(Collectors.groupingBy(s->s.getBrandQuotationProcessId()));
        for (DvBrandQuotationProcessVo dvBrandQuotationProcess : dvBrandQuotationProcessList) {
            dvBrandQuotationProcess.setToolList(toolMap.getOrDefault(dvBrandQuotationProcess.getBrandQuotationProcessId(), new ArrayList<DevBrandQuotationProcessToolVo>()));
            dvBrandQuotationProcess.setQcindexList(qcindexMap.getOrDefault(dvBrandQuotationProcess.getBrandQuotationProcessId(),new ArrayList<DevBrandQuotationProcessQcindexVo>()));

        }

        return dvBrandQuotationVo;

    }

    /**
     * 查询【请填写功能名称】列表
     *
     * @param devBrandQuotation 【请填写功能名称】
     * @return 【请填写功能名称】
     */
    @Override
    public List<DvBrandQuotation> selectDevBrandQuotationList(DvBrandQuotation devBrandQuotation)
    {
        return devBrandQuotationMapper.selectDevBrandQuotationList(devBrandQuotation);
    }

    /**
     * 新增【请填写功能名称】
     *
     * @param dvBrandQuotationVo 【请填写功能名称】
     * @return 结果
     */
    @Override
    public int insertDevBrandQuotation(DvBrandQuotationVo dvBrandQuotationVo)
    {  DvBrandQuotation dvBrandQuotation = new DvBrandQuotation();
        BeanUtils.copyProperties(dvBrandQuotationVo,dvBrandQuotation);
        dvBrandQuotation.setCreateTime(DateUtils.getNowDate());
        dvBrandQuotation.setCreateBy(getUsername());

        int i = devBrandQuotationMapper.insertDevBrandQuotation(dvBrandQuotation);
        Long brandquotationtId = dvBrandQuotation.getBrandQuotationId();

        // 获取打样申请BOM列表
        List<DvBrandQuotationBom> bomList = dvBrandQuotationVo.getBomList();
        for (DvBrandQuotationBom dvBrandQuotationBom : bomList) {
            dvBrandQuotationBom.setBrandQuotationId(brandquotationtId);
            DvBrandQuotationBomMapper.insertDevBrandQuotationBom(dvBrandQuotationBom);
        }

        // 获取打样工序
        List<DvBrandQuotationProcessVo> processList = dvBrandQuotationVo.getProcessList();
        for (DvBrandQuotationProcessVo dvBrandQuotationProcessVo : processList) {
            dvBrandQuotationProcessVo.setBrandQuotationId(brandquotationtId);
            // 保存工序
            DvBrandQuotationProcess dvBrandQuotationProcess = dvBrandQuotationProcessVo.getDevBrandQuotationProcess(dvBrandQuotationProcessVo);
            dvBrandQuotationProcessMapper.insertDevBrandQuotationProcess(dvBrandQuotationProcess);
            Long brandQuotationProcessId = dvBrandQuotationProcess.getBrandQuotationProcessId();
            // 获取工序物料-保存
            List<DvBrandQuotationProcessItem> proPrototypeRequestProcessItemList = dvBrandQuotationProcessVo.getProcessItemList();
            for (DvBrandQuotationProcessItem dvBrandQuotationProcessItem : proPrototypeRequestProcessItemList) {
                dvBrandQuotationProcessItem.setBrandQuotationProcessId(brandQuotationProcessId);
                dvBrandQuotationProcessItemMapper.insertDevBrandQuotationProcessItem(dvBrandQuotationProcessItem);
            }
            //检验项
            List<DevBrandQuotationProcessQcindexVo> qcindexList = dvBrandQuotationProcessVo.getQcindexList();
            qcindexList.forEach(s->{
                DevBrandQuotationProcessQcindex temp = new DevBrandQuotationProcessQcindex();
                BeanUtil.copyProperties(s, temp);
                temp.setBrandQuotationId(brandquotationtId);
                temp.setBrandQuotationProcessId(brandQuotationProcessId);
                devBrandQuotationProcessQcindexMapper.insertDevBrandQuotationProcessQcindex(temp);
            });
            //工装量具
            List<DevBrandQuotationProcessToolVo> toolList = dvBrandQuotationProcessVo.getToolList();
            toolList.forEach(s->{
                DevBrandQuotationProcessTool temp = new DevBrandQuotationProcessTool();
                BeanUtil.copyProperties(s, temp);
                temp.setBrandQuotationId(brandquotationtId);
                temp.setBrandQuotationProcessId(brandQuotationProcessId);
                devBrandQuotationProcessToolMapper.insertDevBrandQuotationProcessTool(temp);
            });
        }
        return i;
    }



    /**
     * 修改【请填写功能名称】
     *
     * @param dvBrandQuotationVo 【请填写功能名称】
     * @return 结果
     */
    @Override
    public int updateDevBrandQuotation(DvBrandQuotationVo dvBrandQuotationVo)
    {
        DvBrandQuotation dvBrandQuotation = new DvBrandQuotation();
        BeanUtil.copyProperties(dvBrandQuotationVo, dvBrandQuotation);
        dvBrandQuotation.setUpdateTime(DateUtils.getNowDate());
        dvBrandQuotation.setUpdateBy(getUsername());
        int i = devBrandQuotationMapper.updateDevBrandQuotation(dvBrandQuotation);
        List<DvBrandQuotationProcessVo> processList = dvBrandQuotationVo.getProcessList();


        DvBrandQuotationProcess processQuery = new DvBrandQuotationProcess();
        processQuery.setBrandQuotationId(dvBrandQuotation.getBrandQuotationId());
        List<DvBrandQuotationProcess> processListDb = dvBrandQuotationProcessMapper.selectDevBrandQuotationProcessList(processQuery);
        if(processList!=null){
            for (DvBrandQuotationProcessVo dvBrandQuotationProcessVo : processList) {
                Long brandQuotationProcessId = dvBrandQuotationProcessVo.getBrandQuotationProcessId();
                // 获取工序物料-保存
                List<DvBrandQuotationProcessItem> dvBrandQuotationProcessItemList = dvBrandQuotationProcessVo.getProcessItemList();
                DvBrandQuotationProcessItem dvBrandQuotationProcessItemQuery = new DvBrandQuotationProcessItem();
                dvBrandQuotationProcessItemQuery.setBrandQuotationProcessId(brandQuotationProcessId);
                List<DvBrandQuotationProcessItem> dvBrandQuotationProcessItemListDb = dvBrandQuotationProcessItemMapper.selectDevBrandQuotationProcessItemList(dvBrandQuotationProcessItemQuery);
                for (DvBrandQuotationProcessItem dvBrandQuotationProcessItem : dvBrandQuotationProcessItemList) {
                    dvBrandQuotationProcessItem.setBrandQuotationProcessId(brandQuotationProcessId);
                    if(dvBrandQuotationProcessItem.getBrandQuotationProcessItemId()==null) {
                        dvBrandQuotationProcessItemMapper.insertDevBrandQuotationProcessItem(dvBrandQuotationProcessItem);
                    }else{
                        dvBrandQuotationProcessItemMapper.updateDevBrandQuotationProcessItem(dvBrandQuotationProcessItem);
                    }
                }
                dvBrandQuotationProcessItemListDb.forEach(v->{
                    if(!dvBrandQuotationProcessItemList.stream().filter(v2->{
                        return v.getBrandQuotationProcessItemId().equals(v2.getBrandQuotationProcessItemId());
                    }).findFirst().isPresent()){
                        dvBrandQuotationProcessMapper.deleteDevBrandQuotationProcessByBrandQuotationProcessId(v.getBrandQuotationProcessItemId());
                    };
                });
                //检验项保存、删除
                List<DevBrandQuotationProcessQcindexVo> devBrandQuotationProcessQcindexList = dvBrandQuotationProcessVo.getQcindexList();
                DevBrandQuotationProcessQcindex devBrandQuotationProcessQcindexQuery = new DevBrandQuotationProcessQcindex();
                devBrandQuotationProcessQcindexQuery.setBrandQuotationProcessId(brandQuotationProcessId);
                List<DevBrandQuotationProcessQcindex> devBrandQuotationProcessQcindexListDb = devBrandQuotationProcessQcindexMapper.selectDevBrandQuotationProcessQcindexList(devBrandQuotationProcessQcindexQuery);
                for (DevBrandQuotationProcessQcindexVo devBrandQuotationProcessQcindexVo : devBrandQuotationProcessQcindexList) {
                    DevBrandQuotationProcessQcindex devBrandQuotationProcessQcindex = new DevBrandQuotationProcessQcindex();
                    BeanUtil.copyProperties(devBrandQuotationProcessQcindexVo, devBrandQuotationProcessQcindex);
                    devBrandQuotationProcessQcindex.setBrandQuotationId(dvBrandQuotationProcessVo.getBrandQuotationId());
                    devBrandQuotationProcessQcindex.setBrandQuotationProcessId(brandQuotationProcessId);
                    if(devBrandQuotationProcessQcindex.getBrandQuotationProcessQcindexId()==null) {
                        devBrandQuotationProcessQcindexMapper.insertDevBrandQuotationProcessQcindex(devBrandQuotationProcessQcindex);
                    }else{
                        devBrandQuotationProcessQcindexMapper.updateDevBrandQuotationProcessQcindex(devBrandQuotationProcessQcindex);
                    }
                }
                devBrandQuotationProcessQcindexListDb.forEach(v->{
                    if(!devBrandQuotationProcessQcindexList.stream().filter(v2->{
                        return v.getBrandQuotationProcessQcindexId().equals(v2.getBrandQuotationProcessQcindexId());
                    }).findFirst().isPresent()){
                        devBrandQuotationProcessQcindexMapper.deleteDevBrandQuotationProcessQcindexByBrandQuotationProcessQcindexId(v.getBrandQuotationProcessQcindexId());
                    };
                });
                //工装
                List<DevBrandQuotationProcessToolVo> devBrandQuotationProcessToolList = dvBrandQuotationProcessVo.getToolList();
                DevBrandQuotationProcessTool devBrandQuotationProcessToolQuery = new DevBrandQuotationProcessTool();
                devBrandQuotationProcessToolQuery.setBrandQuotationProcessId(brandQuotationProcessId);
                List<DevBrandQuotationProcessTool> devBrandQuotationProcessToolListDb = devBrandQuotationProcessToolMapper.selectDevBrandQuotationProcessToolList(devBrandQuotationProcessToolQuery);
                for (DevBrandQuotationProcessToolVo devBrandQuotationProcessToolVo : devBrandQuotationProcessToolList) {
                    DevBrandQuotationProcessTool devBrandQuotationProcessTool = new DevBrandQuotationProcessTool();
                    BeanUtil.copyProperties(devBrandQuotationProcessToolVo, devBrandQuotationProcessTool);
                    devBrandQuotationProcessTool.setBrandQuotationProcessId(brandQuotationProcessId);
                    devBrandQuotationProcessTool.setBrandQuotationId(dvBrandQuotationProcessVo.getBrandQuotationId());
                    if(devBrandQuotationProcessTool.getBrandQuotationProcessToolId()==null) {
                        devBrandQuotationProcessToolMapper.insertDevBrandQuotationProcessTool(devBrandQuotationProcessTool);
                    }else{
                        devBrandQuotationProcessToolMapper.updateDevBrandQuotationProcessTool(devBrandQuotationProcessTool);
                    }
                }
                devBrandQuotationProcessToolListDb.forEach(v->{
                    if(!devBrandQuotationProcessToolList.stream().filter(v2->{
                        return v.getBrandQuotationProcessToolId().equals(v2.getBrandQuotationProcessToolId());
                    }).findFirst().isPresent()){
                        devBrandQuotationProcessToolMapper.deleteDevBrandQuotationProcessToolByBrandQuotationProcessToolId(v.getBrandQuotationProcessToolId());
                    };
                });
            }
        }
        return i;
    }

    /**
     * 批量删除【请填写功能名称】
     *
     * @param brandQuotationIds 需要删除的【请填写功能名称】主键
     * @return 结果
     */
    @Override
    public int deleteDevBrandQuotationByBrandQuotationIds(Long[] brandQuotationIds)
    {
        return devBrandQuotationMapper.deleteDevBrandQuotationByBrandQuotationIds(brandQuotationIds);
    }

    /**
     * 删除【请填写功能名称】信息
     *
     * @param brandQuotationId 【请填写功能名称】主键
     * @return 结果
     */
    @Override
    public int deleteDevBrandQuotationByBrandQuotationId(Long brandQuotationId)
    {
        return devBrandQuotationMapper.deleteDevBrandQuotationByBrandQuotationId(brandQuotationId);
    }
}
