package com.ximai.mes.dv.domain.vo;

import com.ximai.common.annotation.Excel;
import com.ximai.mes.dv.domain.devBrandQuotation.DvBrandQuotationProcess;
import com.ximai.mes.dv.domain.devBrandQuotation.DvBrandQuotationProcessItem;
import org.springframework.beans.BeanUtils;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;

public class DvBrandQuotationProcessVo implements Serializable {
    private static final long serialVersionUID = 1L;

    /** ID */
    private Long brandQuotationProcessId;

    /** 品牌报价ID */
    @Excel(name = "品牌报价单ID")
    private Long brandQuotationId;

    /** 记录ID */
    @Excel(name = "记录ID")
    private Long recordId;





    /** 工作站ID */
    @Excel(name = "工作站ID")
    private Long workstationId;


    /** 工作站 */
    @Excel(name = "工作站")
    private String workstationName;




    /** 编号 */
    @Excel(name = "编号")
    private int orderNum;

    /** 工序id */
    private Long processId;

    /** 工序名称 */
    @Excel(name = "工序名称")
    private String processName;

    /** 工序编码 */
    @Excel(name = "工序编码")
    private String processCode;

    /** 下一道工序的名称 */
    @Excel(name ="下一道工序的名称")
    private String nextProcessName;


    /** 与下一道工序的关系 */
    @Excel(name = "与下一道工序的关系")
    private String linkType;

    /** 甘特图颜色 */
    private String colorCode;

    /** 准备时间 */
    @Excel(name = "准备时间")
    private Long defaultPreTime;

    /** 等待时间 */
    @Excel(name = "等待时间")
    private Long defaultSufTime;

    /** 关键工序 */
    @Excel(name = "关键工序")
    private String keyFlag;

    /** 是否检验 */
    @Excel(name = "是否检验")
    private String isCheck;



    /** 标准工时 */
    @Excel(name = "标准工时")
    private BigDecimal stdWorkingTime;


    /** 备注 */
    private String remark;

    /** 工序物料 */
    private List<DvBrandQuotationProcessItem> processItemList;

    private List<DevBrandQuotationProcessQcindexVo> qcindexList;

    private List<DevBrandQuotationProcessToolVo> toolList;

    public List<DevBrandQuotationProcessQcindexVo> getQcindexList() {
        return qcindexList;
    }

    public void setQcindexList(List<DevBrandQuotationProcessQcindexVo> qcindexList) {
        this.qcindexList = qcindexList;
    }

    public List<DevBrandQuotationProcessToolVo> getToolList() {
        return toolList;
    }

    public void setToolList(List<DevBrandQuotationProcessToolVo> toolList) {
        this.toolList = toolList;
    }

    public List<DvBrandQuotationProcessItem> getProcessItemList() {
        return processItemList;
    }

    public void setProcessItemList(List<DvBrandQuotationProcessItem> processItemList) {
        this.processItemList = processItemList;
    }

    public DvBrandQuotationProcess getDevBrandQuotationProcess(DvBrandQuotationProcessVo dvBrandQuotationProcessVo){
        DvBrandQuotationProcess dvBrandQuotationProcess = new DvBrandQuotationProcess();
        BeanUtils.copyProperties(dvBrandQuotationProcessVo,dvBrandQuotationProcess);
        return  dvBrandQuotationProcess;
    }
    public BigDecimal getStdWorkingTime() {
        return stdWorkingTime;
    }

    public Long getBrandQuotationProcessId() {
        return brandQuotationProcessId;
    }

    public void setBrandQuotationProcessId(Long brandQuotationProcessId) {
        this.brandQuotationProcessId = brandQuotationProcessId;
    }


    public String getIsCheck() {
        return isCheck;
    }

    public void setIsCheck(String isCheck) {
        this.isCheck = isCheck;
    }

    public void setStdWorkingTime(BigDecimal stdWorkingTime) {
        this.stdWorkingTime = stdWorkingTime;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark;
    }

    public Long getBrandQuotationId() {
        return brandQuotationId;
    }

    public void setBrandQuotationId(Long brandQuotationId) {
        this.brandQuotationId = brandQuotationId;
    }

    public Long getRecordId() {
        return recordId;
    }

    public void setRecordId(Long recordId) {
        this.recordId = recordId;
    }



    public Long getWorkstationId() {
        return workstationId;
    }

    public void setWorkstationId(Long workstationId) {
        this.workstationId = workstationId;
    }

    public String getWorkstationName() {
        return workstationName;
    }

    public void setWorkstationName(String workstationName) {
        this.workstationName = workstationName;
    }

    public String getLinkType() {
        return linkType;
    }

    public void setLinkType(String linkType) {
        this.linkType = linkType;
    }


    public Long getDefaultPreTime() {
        return defaultPreTime;
    }

    public void setDefaultPreTime(Long defaultPreTime) {
        this.defaultPreTime = defaultPreTime;
    }

    public Long getDefaultSufTime() {
        return defaultSufTime;
    }

    public void setDefaultSufTime(Long defaultSufTime) {
        this.defaultSufTime = defaultSufTime;
    }

    public String getKeyFlag() {
        return keyFlag;
    }

    public void setKeyFlag(String keyFlag) {
        this.keyFlag = keyFlag;
    }

    public int getOrderNum() {
        return orderNum;
    }

    public void setOrderNum(int orderNum) {
        this.orderNum = orderNum;
    }

    public Long getProcessId() {
        return processId;
    }

    public void setProcessId(Long processId) {
        this.processId = processId;
    }

    public String getProcessName() {
        return processName;
    }

    public void setProcessName(String processName) {
        this.processName = processName;
    }

    public String getProcessCode() {
        return processCode;
    }

    public void setProcessCode(String processCode) {
        this.processCode = processCode;
    }

    public String getNextProcessName() {
        return nextProcessName;
    }

    public void setNextProcessName(String nextProcessName) {
        this.nextProcessName = nextProcessName;
    }

    public String getColorCode() {
        return colorCode;
    }

    public void setColorCode(String colorCode) {
        this.colorCode = colorCode;
    }


}
