package com.ximai.mes.constant;

/**
 * 任务单状态
 * @ Author: chicheng.li
 * @ Date  : 2024/2/4
 */
public enum CalPlanWorkDayEnum {

    /**
     * work
     */
    NO_WEEKEND(1, "工作"),

    /**
     * workend
     */
    WEEKEND(2,"假期");

    /**
     * Lock type
     */
    private final Integer type;
    private final String value;

    CalPlanWorkDayEnum(Integer type, String value) {
        this.type = type;
        this.value = value;
    }

    public Integer getType() {
        return type;
    }

    public String getValue() {
        return value;
    }

    public static String get(Integer type){
        for(CalPlanWorkDayEnum temp : CalPlanWorkDayEnum.values()){
            if(temp.getType().equals(type)){
                return temp.getValue();
            }
        }
        return "未知类型";
//        throw new RuntimeException("异常上机类型");
    }
}
