package com.ximai.mes.aspect;

import cn.hutool.core.util.ObjectUtil;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.utils.DictUtils;
import com.ximai.framework.config.ApplicationConfig;
import com.ximai.framework.manager.AsyncManager;
import com.ximai.mes.wm.domain.WmBarcodeConfig;
import com.ximai.mes.wm.service.IWmBarcodeConfigService;
import com.ximai.system.domain.SysConfig;
import com.ximai.system.service.ISysConfigService;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import java.util.List;
import java.util.TimerTask;

@Aspect
@Component
public class MethodExtendedProcessAspect {

    private static final Logger log = LoggerFactory.getLogger(MethodExtendedProcessAspect.class);

    @Autowired
    ApplicationContext applicationContext;
    @Autowired
    ISysConfigService configService;


    /**
     * 根据扩展业务配置执行处理方法
     * @param joinPoint
     * @param extendedProcesses
     * @param returnResult
     */
    @AfterReturning(pointcut = "@annotation(extendedProcesses)",returning = "returnResult")
    public void doAfter(JoinPoint joinPoint, MethodExtendedProcesses extendedProcesses, Object returnResult){
        for(MethodExtendedProcess extendedProcess : extendedProcesses.config()){
            if(ObjectUtil.isNotEmpty(extendedProcess.sysSwitchParam())){
                String val = configService.selectConfigByKey(extendedProcess.sysSwitchParam());
                if("0".equals(val)){
                    return;
                }
            }
            IExtendedProcess process = applicationContext.getBean(extendedProcess.processClz());
            ServletRequestAttributes requestAttributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
            RequestContextHolder.setRequestAttributes(requestAttributes, true);
            if(extendedProcess.newThread()){
                AsyncManager.me().execute(new TimerTask() {
                    @Override
                    public void run() {
                        process.process(joinPoint.getArgs(), returnResult);
                    }
                });
            }else{
                if(extendedProcess.errorCatch()){
                    try {
                        process.process(joinPoint.getArgs(), returnResult);
                    } catch (Exception e){
                        log.error("扩展处理执行失败,", e);
                    }
                }else{
                    process.process(joinPoint.getArgs(), returnResult);
                }
            }
        }
    }

}
