package com.ximai.common.core.dto;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ximai.common.annotation.Excel;
import com.ximai.common.annotation.Excel.ColumnType;
import com.ximai.common.annotation.Excel.Type;
import com.ximai.common.annotation.Excels;
import com.ximai.common.core.domain.BaseEntity;
import com.ximai.common.core.domain.BaseExcelImport;
import com.ximai.common.core.domain.entity.SysDept;
import com.ximai.common.core.domain.entity.SysRole;
import com.ximai.common.utils.excel.I18nField;
import com.ximai.common.utils.excel.converter.LocalDateTimeConverter;
import com.ximai.common.utils.excel.converter.StaticDataMappingConverter;
import com.ximai.common.utils.excel.converter.StaticDataMappingFormat;
import com.ximai.common.xss.Xss;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

import javax.validation.constraints.Email;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;
import java.util.Date;
import java.util.List;
import java.util.Set;

/**
 * 用户对象 sys_user
 */
@Data
@ApiModel("用户导入")
public class SysUserExcelImport {

    /**
     * 用户账号
     */
    @ExcelProperty("登录名称")
    @I18nField("user.userName")
    private String userName;

    /**
     * 用户昵称
     */
    @ExcelProperty("用户名称")
    @I18nField("user.nickName")
    private String nickName;
    /**
     * 用户邮箱
     */
    @ExcelProperty("用户邮箱")
    @I18nField("user.email")
    private String email;

    /**
     * 手机号码
     */
    @ExcelProperty("手机号码")
    @I18nField("user.phonenumber")
    private String phonenumber;

    /**
     * 用户性别
     */
    @ExcelProperty(value = "用户性别", converter = StaticDataMappingConverter.class)
    @StaticDataMappingFormat(value = {"1","2"},excelValue = {"男","女"})
    private String sex;

    @ApiModelProperty("国际化语言")
    private String locale;
}
