package com.ximai.system.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.system.domain.SysApiLog;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 操作日志 数据层
 */
public interface SysApiLogMapper {
    /**
     * 新增操作日志
     *
     * @param apiLog 操作日志对象
     */
    void insertApiLog(SysApiLog apiLog);

    /**
     * 查询系统操作日志集合
     *
     * @param apiLog 操作日志对象
     * @return 操作日志集合
     */
    List<SysApiLog> selectApiLogList(SysApiLog apiLog);

    /**
     * 查询系统操作日志集合
     *
     * @param apiLog 操作日志对象
     * @return 操作日志集合
     */
    @Select(value = "select * from sys_api_log \n" +
            "${ew.customSqlSegment}")
    List<SysApiLog> selectListByQw(@Param("ew") QueryWrapper<SysApiLog> query);


    /**
     * 批量删除系统操作日志
     *
     * @param operIds 需要删除的操作日志ID
     * @return 结果
     */
    int deleteApiLogByIds(Long[] operIds);

    /**
     * 查询操作日志详细
     *
     * @param operId 操作ID
     * @return 操作日志对象
     */
    SysApiLog selectApiLogById(Long operId);

    /**
     * 清空操作日志
     */
    void cleanApiLog();
}
