package com.ximai.mes.tm.domain;

import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 刀模版领用单对象 tm_tool_request_use
 *
 * @author generator
 * @date 2024-02-02
 */
@Data
@NoArgsConstructor
public class TmToolRequestUse extends BaseEntity {
    public TmToolRequestUse(Long toolRequestUseId) {
        this.toolRequestUseId = toolRequestUseId;
    }

    private static final long serialVersionUID = 1L;

    /**
     * 主键id
     */
    @TableId
    private Long toolRequestUseId;

    /**
     * 领用单编码
     */
    @Excel(name = "领用单编码")
    private String toolRequestUseCode;

    /**
     * 申请单id
     */
    @Excel(name = "申请单id")
    private Long toolRequestId;

    /**
     * 工序id
     */
    @Excel(name = "工序id")
    private Long processId;

    private Long taskWorkunitId;
    /**
     * 作业单元id
     */
    @Excel(name = "作业单元id")
    private Long workunitId;

    /**
     * 申请时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "申请时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date requestDate;

    /**
     * 预计开始时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "预计开始时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /**
     * 预计结束时间
     */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "预计结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;

    /**
     * 申请数量
     */
    @Excel(name = "申请数量")
    private Integer requestNum;


    /**
     * 编排单号
     */
    @Excel(name = "编排单号")
    private String arrangeCode;

    //表外字段
    /**
     * 工序名称
     */
    @Excel(name = "工序名称")
    private String processName;
    /**
     * 工作单元名称
     */
    @Excel(name = "工作单元名称")
    private String workunitName;

    private String toolRequestCode;
    private BigDecimal estimatedLifeTime;

    //申请单刀模版子表数据
    private List<TmToolRequestItem> tmToolRequestItemList;

    //领用单刀模版子表数据
    private List<TmToolRequestUseItem> tmToolRequestUseItemList;

    //查询详情返回封装好的数据
    private List<TmTool> tmToolList;

    public List<TmTool> getTmToolList() {
        return tmToolList;
    }

    public void setTmToolList(List<TmTool> tmToolList) {
        this.tmToolList = tmToolList;
    }

    public List<TmToolRequestUseItem> getTmToolRequestUseItemList() {
        return tmToolRequestUseItemList;
    }

    public void setTmToolRequestUseItemList(List<TmToolRequestUseItem> tmToolRequestUseItemList) {
        this.tmToolRequestUseItemList = tmToolRequestUseItemList;
    }

    public List<TmToolRequestItem> getTmToolRequestItemList() {
        return tmToolRequestItemList;
    }

    public void setTmToolRequestItemList(List<TmToolRequestItem> tmToolRequestItemList) {
        this.tmToolRequestItemList = tmToolRequestItemList;
    }

}
