package com.ximai.mes.report.response;

import com.alibaba.excel.annotation.format.NumberFormat;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.ximai.common.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

@Data
public class WorkOrderProgressListResponse {
    private Long workorderId;
    /**
     * 项目号，订单号，生产工单，工单类型，产品编码，产品名称，计划数量，完工数量，在制进度（百分比），需求实际
     */
    @ApiModelProperty("客户项目号")
    @Excel(name = "客户项目号")
    private String customerProjectNo;


    @ApiModelProperty("订单单号")
    @Excel(name = "订单单号")
    private String orderCode;

    @ApiModelProperty( "工单编码")
    @Excel(name = "生产工单")
    private String workorderCode;

    @ApiModelProperty("产线")
    @Excel(name = "产品名称")
    private String lineName;

    @ApiModelProperty("工单状态")
    private String status;
    /**
     * 工单类型
     */
    @ApiModelProperty(    "工单类型")
    @Excel(name = "工单类型")
    private String workorderType;
    /**
     * 产品编号
     */
    @ApiModelProperty(   "产品编号")
    @Excel(name = "产品编号")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty(   "产品名称")
    @Excel(name = "产品名称")
    private String productName;

    @ApiModelProperty("计划数量")
    @Excel(name = "计划数量")
    @NumberFormat(value = "0.00")
    private BigDecimal quantity;
    /**
     * 已生产数量
     */
    @ApiModelProperty("已生产数量")
    @Excel(name = "完工数量")
    @NumberFormat(value = "0.00")
    private BigDecimal quantityProduced;
    /**
     * 已生产数量
     */
    @ApiModelProperty("在制进度")
    @Excel(name = "在制进度%")
    @NumberFormat(value = "0.00")
    private BigDecimal quantityMu;

    @ApiModelProperty("需求时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "需求时间", dateFormat = "yyyy-MM-dd HH:mm:ss")
    private Date requestDate;

    @ApiModelProperty("订单序号")
    @Excel(name = "订单序号")
    private String orderSerial;
    @ApiModelProperty("排产次数")
    @Excel(name = "排产次数")
    private String taskBatch;
}

