package com.ximai.mes.report.response;

import com.ximai.common.annotation.Excel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

@Data
public class FeedbackResponseExportByProcess {

    /**
     * 工序名称
     */
    @ApiModelProperty(     "工序编码")
    @Excel(name = "工序编码")
    private String processCode;
    /**
     * 工序名称
     */
    @ApiModelProperty(     "工序名称")
    @Excel(name = "工序名称")
    private String processName;


    /**
     * 本次报工数量
     */
    @ApiModelProperty(     "报工数量")
    @Excel(name = "报工数量")
    private BigDecimal quantityFeedback;

    /**
     * 合格品数量
     */
    @ApiModelProperty(     "合格数量")
    @Excel(name = "合格数量")
    private BigDecimal quantityQualify;

    /**
     * 不良品数量
     */
    @ApiModelProperty(     "不合格数量")
    @Excel(name = "不合格数量")
    private BigDecimal quantityUnqualify;




    @ApiModelProperty("良率")
    @Excel(name = "良率")
    private String qualificationRate;
}
