package com.ximai.mes.remote.dto;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.ximai.mes.config.TrimStringDeserializer;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;

/**
 * 工单BOM对象 ProWorkorderBomErpDto
 *
 * @date 2024-10-18
 */
@Data
public class ProWorkorderBomErpDto
{
    private static final long serialVersionUID = 1L;

    @ApiModelProperty("工单单别")
    @JsonProperty("tb001")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String orderSource;

    @ApiModelProperty("工单单号")
    @JsonProperty("tb002")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String workorderCode;

    @ApiModelProperty("材料品号")
    @JsonProperty("tb003")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String itemCode;

    @ApiModelProperty("工艺")
    @JsonProperty("tb006")
    @JsonDeserialize(using = TrimStringDeserializer.class)
    private String opName;

    @ApiModelProperty("需领用量")
    @JsonProperty("tb004")
    private BigDecimal quantity;
}
