package com.ximai.mes.remote.dto;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.ximai.common.core.domain.BaseEntity;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.Date;

/**
 * 物料对象 MdItemErpQuery
 *
 * @date 2024-10-18
 */
@Data
public class MdItemErpQuery extends ErpPageParams
{
    @JsonProperty("mb001")
    @ApiModelProperty("品号")
    private String itemCode;

    @JsonProperty("mb002")
    @ApiModelProperty("品名")
    private String itemName;

    @JsonProperty("neUdf08")
    @ApiModelProperty("同步标识状态-不等于")
    private String syncMarkNe;

    @JsonProperty("mb109")
    @ApiModelProperty("核准状态")
    private String verifyStatus;

    @ApiModelProperty("创建日期-大于等于")
    @JsonFormat(pattern = "yyyyMMddHHmmssSSS")
    private Date gtEqCreateDate;

    @ApiModelProperty("修改日期-大于等于")
    @JsonFormat(pattern = "yyyyMMddHHmmssSSS")
    private Date gtEqModiDate;
}
