package com.ximai.mes.qc.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.qc.domain.QcIndex;

import java.util.List;

/**
 * 检测项Mapper接口
 *
 * @date 2022-05-17
 */
public interface QcIndexMapper extends BaseMapper<QcIndex> {
    /**
     * 查询检测项
     *
     * @param indexId 检测项主键
     * @return 检测项
     */
    QcIndex selectQcIndexByIndexId(Long indexId);

    /**
     * 查询检测项列表
     *
     * @param qcIndex 检测项
     * @return 检测项集合
     */
    List<QcIndex> selectQcIndexList(QcIndex qcIndex);


    QcIndex checkIndexCodeUnique(QcIndex qcIndex);

    QcIndex checkIndexNameUnique(QcIndex qcIndex);


    /**
     * 新增检测项
     *
     * @param qcIndex 检测项
     * @return 结果
     */
    int insertQcIndex(QcIndex qcIndex);

    /**
     * 修改检测项
     *
     * @param qcIndex 检测项
     * @return 结果
     */
    int updateQcIndex(QcIndex qcIndex);

    /**
     * 删除检测项
     *
     * @param indexId 检测项主键
     * @return 结果
     */
    int deleteQcIndexByIndexId(Long indexId);

    /**
     * 批量删除检测项
     *
     * @param indexIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteQcIndexByIndexIds(Long[] indexIds);
}
