package com.ximai.mes.qc.domain.vo;

/**
 * @ Author: chicheng.li
 * @ Date  : 2024/2/4
 */
public enum QcIndexInputType {

    /**
     * 输入框
     */
    INPUT(1,"输入框"),
    /**
     * 选择框
     */
    SELECT(2,"选择框");

    /**
     * Lock type
     */
    private final Integer value;
    private final String text;

    /**
     * Constructor with field of type
     */
    private QcIndexInputType(Integer value, String text) {
        this.value = value;
        this.text = text;
    }

    public Integer getValue() {
        return value;
    }
    public String getText() {
        return text;
    }

    public static QcIndexInputType get(Integer value){
        for(QcIndexInputType temp : QcIndexInputType.values()){
            if(temp.getValue().equals(value)){
                return temp;
            }
        }
        return null;
    }
    public static QcIndexInputType get(String text){
        for(QcIndexInputType temp : QcIndexInputType.values()){
            if(temp.getText().equals(text)){
                return temp;
            }
        }
        return null;
    }
}
