package com.ximai.mes.qc.controller;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.qc.domain.QcTemplateProcess;
import com.ximai.mes.qc.domain.vo.QcTemplateProcessExportExcel;
import com.ximai.mes.qc.domain.vo.QcTemplateProcessImportExcel;
import com.ximai.mes.qc.service.IQcTemplateProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.multipart.MultipartFile;

import javax.servlet.http.HttpServletResponse;
import java.util.ArrayList;
import java.util.List;

/**
 * 检测模板-工序Controller
 *
 * @author generator
 * @date 2024-02-18
 */
@RestController
@RequestMapping("/mes/qc/templateProcess")
public class QcTemplateProcessController extends BaseController {
    @Autowired
    private IQcTemplateProcessService qcTemplateProcessService;

    /**
     * 查询检测模板-工序列表
     */
    @PreAuthorize("@ss.hasPermi('mes:qc:templateProcess:list')")
    @GetMapping("/list")
    public TableDataInfo list(QcTemplateProcess qcTemplateProcess) {
        startPage();
        List<QcTemplateProcess> list = qcTemplateProcessService.selectQcTemplateProcessList(qcTemplateProcess);
        return getDataTable(list);
    }

    /**
     * 获取检测模板-工序详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes:qc:templateProcess:query')")
    @GetMapping(value = "/{id}")
    public AjaxResult getInfo(@PathVariable("id") Long id) {
        return AjaxResult.success(qcTemplateProcessService.selectQcTemplateProcessById(id));
    }


    /**
     * 新增检测模板-工序
     */
    @PreAuthorize("@ss.hasPermi('mes:qc:templateProcess:add')")
    @Log(title = "检测模板-工序", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody QcTemplateProcess qcTemplateProcess) {
        return toAjax(qcTemplateProcessService.insertQcTemplateProcess(qcTemplateProcess));
    }

    /**
     * 修改检测模板-工序
     */
    @PreAuthorize("@ss.hasPermi('mes:qc:templateProcess:edit')")
    @Log(title = "检测模板-工序", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody QcTemplateProcess qcTemplateProcess) {
        return toAjax(qcTemplateProcessService.updateQcTemplateProcess(qcTemplateProcess));
    }

    /**
     * 删除检测模板-工序
     */
    @PreAuthorize("@ss.hasPermi('mes:qc:templateProcess:remove')")
    @Log(title = "检测模板-工序", businessType = BusinessType.DELETE)
    @DeleteMapping("/{ids}")
    public AjaxResult remove(@PathVariable Long[] ids) {
        return toAjax(qcTemplateProcessService.deleteQcTemplateProcessByIds(ids));
    }

    @Log(title = "检测项", businessType = BusinessType.IMPORT)
    @PreAuthorize("@ss.hasPermi('mes:qc:qcindex:import')")
    @PostMapping("/importData")
    public AjaxResult importData(MultipartFile file, boolean updateSupport) throws Exception {
        String operName = getUsername();
        qcTemplateProcessService.importExcel(file, updateSupport, operName);
        return AjaxResult.success();
    }
}
