package com.ximai.mes.pro.service.productionSolution;

import java.util.List;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcessDrawing;
import com.ximai.mes.pro.dto.productionSolution.ProProductionSolutionProcessDrawingCreate;
import com.ximai.mes.pro.dto.productionSolution.ProProductionSolutionProcessDrawingUpdate;
import com.ximai.mes.pro.dto.productionSolution.ProProductionSolutionProcessDrawingDto;

/**
 * 生产版本工序图纸Service接口
 * 
 * @author generator
 * @date 2024-08-29
 */
public interface IProProductionSolutionProcessDrawingService 
{
    /**
     * 查询生产版本工序图纸
     *
     * @param productionSolutionProcessFileId 生产版本工序图纸主键
     * @return 生产版本工序图纸
     */
    public ProProductionSolutionProcessDrawingDto selectProProductionSolutionProcessDrawingDtoByProductionSolutionProcessFileId(Long productionSolutionProcessFileId);

    /**
     * 查询生产版本工序图纸
     *
     * @param productionSolutionProcessFileId 生产版本工序图纸主键
     * @return 生产版本工序图纸
     */
    public ProProductionSolutionProcessDrawing selectProProductionSolutionProcessDrawingByProductionSolutionProcessFileId(Long productionSolutionProcessFileId);

    /**
     * 查询生产版本工序图纸列表
     *
     * @param proProductionSolutionProcessDrawing 生产版本工序图纸
     * @return 生产版本工序图纸集合
     */
    public List<ProProductionSolutionProcessDrawingDto> selectProProductionSolutionProcessDrawingList(ProProductionSolutionProcessDrawing proProductionSolutionProcessDrawing);

    /**
     * 查询生产版本工序图纸列表
     *
     * @param proProductionSolutionProcessDrawingQuery 生产版本工序图纸
     * @return 生产版本工序图纸集合
     */
    public List<ProProductionSolutionProcessDrawing> selectProProductionSolutionProcessDrawingList(QueryWrapper<ProProductionSolutionProcessDrawing> proProductionSolutionProcessDrawingQuery);


    /**
     * 查询生产版本工序图纸列表
     *
     * @param proProductionSolutionProcessDrawingQuery 生产版本工序图纸
     * @return 生产版本工序图纸集合
     */
    public List<ProProductionSolutionProcessDrawing> selectProcessDrawingJoinSolution(QueryWrapper<ProProductionSolutionProcessDrawing> proProductionSolutionProcessDrawingQuery);

    /**
     * 新增生产版本工序图纸
     * 
     * @param proProductionSolutionProcessDrawing 生产版本工序图纸
     * @return 结果
     */
    public int insertProProductionSolutionProcessDrawing(ProProductionSolutionProcessDrawingCreate proProductionSolutionProcessDrawing);

    /**
     * 修改生产版本工序图纸
     * 
     * @param proProductionSolutionProcessDrawing 生产版本工序图纸
     * @return 结果
     */
    public int updateProProductionSolutionProcessDrawing(ProProductionSolutionProcessDrawingUpdate proProductionSolutionProcessDrawing);

    /**
     * 批量删除生产版本工序图纸
     * 
     * @param productionSolutionProcessFileIds 需要删除的生产版本工序图纸主键集合
     * @return 结果
     */
    public int deleteProProductionSolutionProcessDrawingByProductionSolutionProcessFileIds(Long[] productionSolutionProcessFileIds);

    /**
     * 删除生产版本工序图纸信息
     * 
     * @param productionSolutionProcessFileId 生产版本工序图纸主键
     * @return 结果
     */
    public int deleteProProductionSolutionProcessDrawingByProductionSolutionProcessFileId(Long productionSolutionProcessFileId);
}
