package com.ximai.mes.pro.service.productionMake;

import java.util.List;
import com.ximai.mes.pro.domain.productionMake.ProProductionMakeProcessItem;

/**
 * 量产制作工序物料Service接口
 *
 * @author chicheng.li
 * @date 2024-01-23
 */
public interface IProProductionMakeProcessItemService
{
    /**
     * 查询量产制作工序物料
     *
     * @param productionMakeProcessItemId 量产制作工序物料主键
     * @return 量产制作工序物料
     */
    public ProProductionMakeProcessItem selectProProductionMakeProcessItemByProductionMakeProcessItemId(Long productionMakeProcessItemId);

    /**
     * 查询量产制作工序物料列表
     *
     * @param proProductionMakeProcessItem 量产制作工序物料
     * @return 量产制作工序物料集合
     */
    public List<ProProductionMakeProcessItem> selectProProductionMakeProcessItemList(ProProductionMakeProcessItem proProductionMakeProcessItem);

    /**
     * 新增量产制作工序物料
     *
     * @param proProductionMakeProcessItem 量产制作工序物料
     * @return 结果
     */
    public int insertProProductionMakeProcessItem(ProProductionMakeProcessItem proProductionMakeProcessItem);

    /**
     * 修改量产制作工序物料
     *
     * @param proProductionMakeProcessItem 量产制作工序物料
     * @return 结果
     */
    public int updateProProductionMakeProcessItem(ProProductionMakeProcessItem proProductionMakeProcessItem);

    /**
     * 批量删除量产制作工序物料
     *
     * @param productionMakeProcessItemIds 需要删除的量产制作工序物料主键集合
     * @return 结果
     */
    public int deleteProProductionMakeProcessItemByProductionMakeProcessItemIds(Long[] productionMakeProcessItemIds);

    /**
     * 删除量产制作工序物料信息
     *
     * @param productionMakeProcessItemId 量产制作工序物料主键
     * @return 结果
     */
    public int deleteProProductionMakeProcessItemByProductionMakeProcessItemId(Long productionMakeProcessItemId);
}
