package com.ximai.mes.pro.service.impl.productionSolution;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.md.domain.MdItem;
import com.ximai.mes.md.mapper.MdItemMapper;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcessTool;
import com.ximai.mes.pro.domain.vo.ProProductionSolutionProcessToolVo;
import com.ximai.mes.pro.mapper.productionSolution.ProProductionSolutionProcessToolMapper;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionProcessToolService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;


/**
 * 生产版本工序工装夹具Service业务层处理
 *
 * @author generator
 * @date 2024-01-28
 */
@Service
public class ProProductionSolutionProcessToolServiceImpl implements IProProductionSolutionProcessToolService {
    @Autowired
    private ProProductionSolutionProcessToolMapper proProductionSolutionProcessToolMapper;

    @Autowired
    private MdItemMapper mdItemMapper;

    /**
     * 查询生产版本工序工装夹具
     *
     * @param prototypeSolutionProcessToolId 生产版本工序工装夹具主键
     * @return 生产版本工序工装夹具
     */
    @Override
    public ProProductionSolutionProcessTool selectProProductionSolutionProcessToolByPrototypeSolutionProcessToolId(Long prototypeSolutionProcessToolId) {
        return proProductionSolutionProcessToolMapper.selectProProductionSolutionProcessToolByPrototypeSolutionProcessToolId(prototypeSolutionProcessToolId);
    }

    /**
     * 查询生产版本工序工装夹具列表
     *
     * @param proProductionSolutionProcessTool 生产版本工序工装夹具
     * @return 生产版本工序工装夹具
     */
    @Override
    public List<ProProductionSolutionProcessTool> selectProProductionSolutionProcessToolList(ProProductionSolutionProcessTool proProductionSolutionProcessTool) {
        return proProductionSolutionProcessToolMapper.selectProProductionSolutionProcessToolList(proProductionSolutionProcessTool);
    }

    @Override
    public List<ProProductionSolutionProcessToolVo> selectProProductionSolutionProcessToolVoList(ProProductionSolutionProcessTool proProductionSolutionProcessTool) {

        List<ProProductionSolutionProcessToolVo> rst = new ArrayList<ProProductionSolutionProcessToolVo>();
        ProProductionSolutionProcessTool query = new ProProductionSolutionProcessTool();
        query.setPrototypeSolutionId(proProductionSolutionProcessTool.getPrototypeSolutionId());
        List<ProProductionSolutionProcessTool> list = proProductionSolutionProcessToolMapper.selectProProductionSolutionProcessToolList(query);
        List<Long> ids = list.stream().map(ProProductionSolutionProcessTool::getToolId).collect(Collectors.toList());
        Map<Long, MdItem> toolMap = new HashMap<Long, MdItem>();
        if (ids.size() > 0) {
            toolMap.putAll(mdItemMapper.selectBatchIds(ids).stream().collect(Collectors.toMap(MdItem::getItemId, s -> s)));
        }
        list.forEach(s -> {
            ProProductionSolutionProcessToolVo vo = new ProProductionSolutionProcessToolVo();
            BeanUtil.copyProperties(s, vo);
            if (toolMap.containsKey(s.getToolId())) {
                BeanUtil.copyProperties(toolMap.get(s.getToolId()), vo);
            }
            rst.add(vo);
        });
        return rst;


    }


    /**
     * 新增生产版本工序工装夹具
     *
     * @param proProductionSolutionProcessTool 生产版本工序工装夹具
     * @return 结果
     */
    @Override
    public int insertProProductionSolutionProcessTool(ProProductionSolutionProcessTool proProductionSolutionProcessTool) {
        return proProductionSolutionProcessToolMapper.insertProProductionSolutionProcessTool(proProductionSolutionProcessTool);
    }

    /**
     * 修改生产版本工序工装夹具
     *
     * @param proProductionSolutionProcessTool 生产版本工序工装夹具
     * @return 结果
     */
    @Override
    public int updateProProductionSolutionProcessTool(ProProductionSolutionProcessTool proProductionSolutionProcessTool) {
        return proProductionSolutionProcessToolMapper.updateProProductionSolutionProcessTool(proProductionSolutionProcessTool);
    }

    /**
     * 批量删除生产版本工序工装夹具
     *
     * @param prototypeSolutionProcessToolIds 需要删除的生产版本工序工装夹具主键
     * @return 结果
     */
    @Override
    public int deleteProProductionSolutionProcessToolByPrototypeSolutionProcessToolIds(Long[] prototypeSolutionProcessToolIds) {
        return proProductionSolutionProcessToolMapper.deleteProProductionSolutionProcessToolByPrototypeSolutionProcessToolIds(prototypeSolutionProcessToolIds);
    }

    /**
     * 删除生产版本工序工装夹具信息
     *
     * @param prototypeSolutionProcessToolId 生产版本工序工装夹具主键
     * @return 结果
     */
    @Override
    public int deleteProProductionSolutionProcessToolByPrototypeSolutionProcessToolId(Long prototypeSolutionProcessToolId) {
        return proProductionSolutionProcessToolMapper.deleteProProductionSolutionProcessToolByPrototypeSolutionProcessToolId(prototypeSolutionProcessToolId);
    }
}
