package com.ximai.mes.pro.service.impl.proWorkOrder;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.utils.sign.Md5Utils;
import com.ximai.mes.md.domain.MdItem;
import com.ximai.mes.md.domain.MdProductLook;
import com.ximai.mes.md.service.IMdItemService;
import com.ximai.mes.md.service.IMdProductLookService;
import com.ximai.mes.md.service.IMdProductPublishedConfService;
import com.ximai.mes.pro.domain.proWorkOrder.*;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolution;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionSpecificationSheet;
import com.ximai.mes.pro.domain.vo.ProProductionSolutionVo;
import com.ximai.mes.pro.domain.vo.ProWorkOrderProcessVo;
import com.ximai.mes.pro.mapper.proWorkOrder.ProWorkOrderArrangeRuleValMapper;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderArrangeRuleValService;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderProcessItemService;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderProcessService;
import com.ximai.mes.pro.service.proWorkOrder.IProWorkOrderProcessToolService;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionService;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionSpecificationSheetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * 工单编排规则属性唯一值Service业务层处理
 *
 * @author generator
 * @date 2024-03-26
 */
@Service
public class ProWorkOrderArrangeRuleValServiceImpl implements IProWorkOrderArrangeRuleValService {
    @Autowired
    private ProWorkOrderArrangeRuleValMapper proWorkOrderArrangeRuleValMapper;
    @Autowired
    private IMdItemService mdItemService;
    @Autowired
    private IProProductionSolutionService proProductionSolutionService;
    @Autowired
    private IProProductionSolutionSpecificationSheetService proProductionSolutionSpecificationSheetService;
    @Autowired
    private IProWorkOrderProcessService proWorkOrderProcessService;
    @Autowired
    private IProWorkOrderProcessItemService proWorkOrderProcessItemService;
    @Autowired
    private IProWorkOrderProcessToolService proWorkOrderProcessToolService;
    @Autowired
    private IMdProductLookService mdProductLookService;
    @Autowired
    private IMdProductPublishedConfService mdProductPublishedConfService;

    /**
     * 查询工单编排规则属性唯一值
     *
     * @param arrangeRuleId 工单编排规则属性唯一值主键
     * @return 工单编排规则属性唯一值
     */
    @Override
    public ProWorkOrderArrangeRuleVal selectProWorkOrderArrangeRuleValByArrangeRuleId(Long arrangeRuleId) {
        return proWorkOrderArrangeRuleValMapper.selectProWorkOrderArrangeRuleValByArrangeRuleId(arrangeRuleId);
    }

    /**
     * 查询工单编排规则属性唯一值列表
     *
     * @param proWorkOrderArrangeRuleVal 工单编排规则属性唯一值
     * @return 工单编排规则属性唯一值
     */
    @Override
    public List<ProWorkOrderArrangeRuleVal> selectProWorkOrderArrangeRuleValList(ProWorkOrderArrangeRuleVal proWorkOrderArrangeRuleVal) {
        return proWorkOrderArrangeRuleValMapper.selectProWorkOrderArrangeRuleValList(proWorkOrderArrangeRuleVal);
    }

    /**
     * 新增工单编排规则属性唯一值
     *
     * @param proWorkOrderArrangeRuleVal 工单编排规则属性唯一值
     * @return 结果
     */
    @Override
    public int insertProWorkOrderArrangeRuleVal(ProWorkOrderArrangeRuleVal proWorkOrderArrangeRuleVal) {
        proWorkOrderArrangeRuleVal.createAction();
        return proWorkOrderArrangeRuleValMapper.insertProWorkOrderArrangeRuleVal(proWorkOrderArrangeRuleVal);
    }

    /**
     * 修改工单编排规则属性唯一值
     *
     * @param proWorkOrderArrangeRuleVal 工单编排规则属性唯一值
     * @return 结果
     */
    @Override
    public int updateProWorkOrderArrangeRuleVal(ProWorkOrderArrangeRuleVal proWorkOrderArrangeRuleVal) {
        proWorkOrderArrangeRuleVal.updateAction();
        return proWorkOrderArrangeRuleValMapper.updateProWorkOrderArrangeRuleVal(proWorkOrderArrangeRuleVal);
    }

    /**
     * 批量删除工单编排规则属性唯一值
     *
     * @param arrangeRuleIds 需要删除的工单编排规则属性唯一值主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderArrangeRuleValByArrangeRuleIds(Long[] arrangeRuleIds) {
        return proWorkOrderArrangeRuleValMapper.deleteProWorkOrderArrangeRuleValByArrangeRuleIds(arrangeRuleIds);
    }

    /**
     * 删除工单编排规则属性唯一值信息
     *
     * @param arrangeRuleId 工单编排规则属性唯一值主键
     * @return 结果
     */
    @Override
    public int deleteProWorkOrderArrangeRuleValByArrangeRuleId(Long arrangeRuleId) {
        return proWorkOrderArrangeRuleValMapper.deleteProWorkOrderArrangeRuleValByArrangeRuleId(arrangeRuleId);
    }

    @Override
    public void insertProWorkOrderArrangeRuleVal(ProWorkorder proWorkorder) {
        ProWorkOrderArrangeRuleVal workOrderArrangeRuleVal = new ProWorkOrderArrangeRuleVal();
        MdItem mdItem = mdItemService.selectMdItemById(proWorkorder.getProductId());
        ProWorkOrderProcess proWorkOrderProcessQuery = new ProWorkOrderProcess();
        proWorkOrderProcessQuery.setWorkorderId(proWorkorder.getWorkorderId());
        List<ProWorkOrderProcessVo> processList = proWorkOrderProcessService.selectProWorkOrderProcessList(proWorkOrderProcessQuery);
        workOrderArrangeRuleVal.setWorkorderId(proWorkorder.getWorkorderId());
        //产品
        workOrderArrangeRuleVal.setItemTypeId(mdItem.getItemTypeId());
        workOrderArrangeRuleVal.setItemTypeName(mdItem.getItemTypeName());
        //查询生产规格书
        ProProductionSolutionVo proProductionSolution = proProductionSolutionService.selectProProductionSolutionByProductionSolutionId(proWorkorder.getProductionSolutionId());
        if (proProductionSolution != null) {
            ProProductionSolutionSpecificationSheet specificationSheet = proProductionSolutionSpecificationSheetService.selectSpecificationSheetByProductionSolutionId(proProductionSolution.getProductionSolutionId());
            if (specificationSheet != null) {
                workOrderArrangeRuleVal.setLength(specificationSheet.getLength() == null ? null : specificationSheet.getLength() + "");
                workOrderArrangeRuleVal.setWidth(specificationSheet.getWidth() == null ? null : specificationSheet.getWidth() + "");
                workOrderArrangeRuleVal.setProductMaterial(specificationSheet.getProductMaterial());
                workOrderArrangeRuleVal.setFrontImg(specificationSheet.getFrontImg());
                workOrderArrangeRuleVal.setBlownFilmWidth(specificationSheet.getBlownFilmWidth() == null ? null : specificationSheet.getBlownFilmWidth() + "");
                workOrderArrangeRuleVal.setBlownFilmThickness(specificationSheet.getBlownFilmThickness() == null ? null : specificationSheet.getBlownFilmThickness() + "");
                workOrderArrangeRuleVal.setPrintingWidth(specificationSheet.getPrintingWidth() == null ? null : specificationSheet.getPrintingWidth() + "");
                //排版参数(上下间距)
                if (specificationSheet.getColdoubleCutspacing() == null && specificationSheet.getRowdoubleCutspacing() == null) {
                    workOrderArrangeRuleVal.setSpacing(null);
                } else {
                    workOrderArrangeRuleVal.setSpacing((specificationSheet.getColdoubleCutspacing() == null ? null : specificationSheet.getColdoubleCutspacing()) + "" +
                            (specificationSheet.getRowdoubleCutspacing() == null ? null : specificationSheet.getRowdoubleCutspacing()));
                }
            }
        }
        //产品外观
        MdProductLook productLook = mdProductLookService.selectMdProductLookByItemId(mdItem.getItemId());
        if (productLook != null) {
            workOrderArrangeRuleVal.setShape(productLook.getShape());
        }
        //工单
        workOrderArrangeRuleVal.setItemCode(proWorkorder.getProductCode());
        workOrderArrangeRuleVal.setRouteCode(this.processRoute(processList));
        processList.forEach(s -> {
            Map<Long, String> bomMapping = this.arrangeRuleValWithBom(proWorkorder, processList);
            Map<Long, String> toolMapping = this.arrangeRuleValWithTool(proWorkorder, processList);
            workOrderArrangeRuleVal.setProcessId(s.getProcessId() + "");
            workOrderArrangeRuleVal.setProcessName(s.getProcessName());
            //物料清单
            workOrderArrangeRuleVal.setProcessCode(bomMapping.get(s.getProcessId()));
            //工装夹具
            workOrderArrangeRuleVal.setToolList(toolMapping.get(s.getProcessId()));
            workOrderArrangeRuleVal.setApiFlag(true);
            this.insertProWorkOrderArrangeRuleVal(workOrderArrangeRuleVal);
        });
    }

    //工序名称+工序控制码一致
    private String processRoute(List<ProWorkOrderProcessVo> processList) {
        String ids = processList.stream().map(s2 -> s2.getProcessName() + s2.getControlCode() +"").sorted().collect(Collectors.joining(","));
        return Md5Utils.hash(ids);
    }

    //BOM主键排序后MD5
    public Map<Long, String> arrangeRuleValWithBom(ProWorkorder proWorkorder, List<ProWorkOrderProcessVo> processList) {
        Map<Long, String> rst = new HashMap<>();
        processList.forEach(s -> {
            ProWorkOrderProcessItem query = new ProWorkOrderProcessItem();
            query.setWorkorderProcessId(s.getWorkorderProcessId());
            List<ProWorkOrderProcessItem> processItemList = proWorkOrderProcessItemService.selectProWorkOrderProcessItemList(query);
            String itemIds = processItemList.stream().map(s2 -> s2.getItemId() + "").sorted().collect(Collectors.joining(","));
            rst.put(s.getProcessId(), Md5Utils.hash(itemIds));
        });
        return rst;
    }

    /**
     * 工装量具排序后MD5
     *
     * @param proWorkorder
     * @return
     */
    public Map<Long, String> arrangeRuleValWithTool(ProWorkorder proWorkorder, List<ProWorkOrderProcessVo> processList) {
        Map<Long, String> rst = new HashMap<Long, String>();
        processList.forEach(s -> {
            ProWorkOrderProcessTool query = new ProWorkOrderProcessTool();
            query.setWorkorderProcessId(s.getWorkorderProcessId());
            List<ProWorkOrderProcessTool> processToolList = proWorkOrderProcessToolService.selectProWorkOrderProcessToolList(query);
            String itemIds = processToolList.stream().map(s2 -> s2.getToolId() + "").sorted().collect(Collectors.joining(","));
            rst.put(s.getProcessId(), Md5Utils.hash(itemIds));
        });
        return rst;
    }

    @Override
    public List<Map<String, Object>> selectProWorkOrderArrangeRuleVal(QueryWrapper<ProWorkOrderArrangeRuleVal> query) {
        return proWorkOrderArrangeRuleValMapper.selectProWorkOrderArrangeRuleVal(query);
    }

    @Override
    public void deleteProWorkOrderArrangeRuleVal(Long workorderId) {
        proWorkOrderArrangeRuleValMapper.deleteByWorkorderId(workorderId);
    }
}
