package com.ximai.mes.pro.service;

import java.util.List;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.mes.pro.domain.ProStorageDetailRecord;
import com.ximai.mes.pro.dto.ProStorageDetailRecordCreate;
import com.ximai.mes.pro.dto.ProStorageDetailRecordUpdate;
import com.ximai.mes.pro.dto.ProStorageDetailRecordDto;

/**
 * 入库明细记录Service接口
 * 
 * @author generator
 * @date 2025-10-12
 */
public interface IProStorageDetailRecordService 
{
    /**
     * 查询入库明细记录
     *
     * @param recordId 入库明细记录主键
     * @return 入库明细记录
     */
    public ProStorageDetailRecordDto selectProStorageDetailRecordDtoByRecordId(Long recordId);

    /**
     * 查询入库明细记录
     *
     * @param recordId 入库明细记录主键
     * @return 入库明细记录
     */
    public ProStorageDetailRecord selectProStorageDetailRecordByRecordId(Long recordId);

    /**
     * 查询入库明细记录列表
     *
     * @param proStorageDetailRecord 入库明细记录
     * @return 入库明细记录集合
     */
    public List<ProStorageDetailRecordDto> selectProStorageDetailRecordList(ProStorageDetailRecord proStorageDetailRecord);

    /**
     * 查询入库明细记录列表
     *
     * @param proStorageDetailRecordQuery 入库明细记录
     * @return 入库明细记录集合
     */
    public List<ProStorageDetailRecord> selectProStorageDetailRecordList(QueryWrapper<ProStorageDetailRecord> proStorageDetailRecordQuery);

    /**
     * 根据箱码查询入库明细记录列表
     *
     * @param boxCode 箱码
     * @return 入库明细记录集合
     */
    public List<ProStorageDetailRecordDto> selectProStorageDetailRecordByBoxCode(String boxCode);

    /**
     * 新增入库明细记录
     * 
     * @param proStorageDetailRecord 入库明细记录
     * @return 结果
     */
    public int insertProStorageDetailRecord(ProStorageDetailRecordCreate proStorageDetailRecord);

    /**
     * 修改入库明细记录
     * 
     * @param proStorageDetailRecord 入库明细记录
     * @return 结果
     */
    public int updateProStorageDetailRecord(ProStorageDetailRecordUpdate proStorageDetailRecord);

    /**
     * 批量删除入库明细记录
     * 
     * @param recordIds 需要删除的入库明细记录主键集合
     * @return 结果
     */
    public int deleteProStorageDetailRecordByRecordIds(Long[] recordIds);

    /**
     * 删除入库明细记录信息
     * 
     * @param recordId 入库明细记录主键
     * @return 结果
     */
    public int deleteProStorageDetailRecordByRecordId(Long recordId);
}

