package com.ximai.mes.pro.service;

import com.ximai.mes.pro.domain.ProRecoilMaterial;
import com.ximai.mes.pro.domain.task.ProTask;

import java.util.List;

/**
 * 反冲料登记Service接口
 *
 * @author generator
 * @date 2024-02-22
 */
public interface IProRecoilMaterialService {
    /**
     * 查询反冲料登记
     *
     * @param id 反冲料登记主键
     * @return 反冲料登记
     */
    ProRecoilMaterial selectProRecoilMaterialById(Long id);

    /**
     * 查询反冲料登记列表
     *
     * @param proRecoilMaterial 反冲料登记
     * @return 反冲料登记集合
     */
    List<ProRecoilMaterial> selectProRecoilMaterialList(ProRecoilMaterial proRecoilMaterial);

    /**
     * 新增反冲料登记
     *
     * @param proRecoilMaterial 反冲料登记
     * @return 结果
     */
    int insertProRecoilMaterial(ProRecoilMaterial proRecoilMaterial);

    /**
     * 修改反冲料登记
     *
     * @param proRecoilMaterial 反冲料登记
     * @return 结果
     */
    int updateProRecoilMaterial(ProRecoilMaterial proRecoilMaterial);

    /**
     * 批量删除反冲料登记
     *
     * @param ids 需要删除的反冲料登记主键集合
     * @return 结果
     */
    int deleteProRecoilMaterialByIds(Long[] ids);

    /**
     * 删除反冲料登记信息
     *
     * @param id 反冲料登记主键
     * @return 结果
     */
    int deleteProRecoilMaterialById(Long id);


    boolean checkRecoilMaterialIsExist(Long id);

    List<ProRecoilMaterial> getRecoilMaterialList(Long taskId);

    // 检查倒冲
    boolean checkRecoilMaterial(ProTask proTask);

    void scan(String code, Long taskId);
}
