package com.ximai.mes.pro.service;

import com.ximai.mes.pro.domain.AppConfig;

import java.util.List;

/**
 * 作业端配置记录Service接口
 *
 * @author generator
 * @date 2024-06-24
 */
public interface IAppConfigService {
    /**
     * 查询作业端配置记录
     *
     * @param id 作业端配置记录主键
     * @return 作业端配置记录
     */
    AppConfig selectAppConfigById(Long id);

    /**
     * 查询作业端配置记录列表
     *
     * @param appConfig 作业端配置记录
     * @return 作业端配置记录集合
     */
    List<AppConfig> selectAppConfigList(AppConfig appConfig);

    /**
     * 新增作业端配置记录
     *
     * @param appConfig 作业端配置记录
     * @return 结果
     */
    int insertAppConfig(AppConfig appConfig);

    /**
     * 修改作业端配置记录
     *
     * @param appConfig 作业端配置记录
     * @return 结果
     */
    int updateAppConfig(AppConfig appConfig);

    /**
     * 批量删除作业端配置记录
     *
     * @param ids 需要删除的作业端配置记录主键集合
     * @return 结果
     */
    int deleteAppConfigByIds(Long[] ids);

    /**
     * 删除作业端配置记录信息
     *
     * @param id 作业端配置记录主键
     * @return 结果
     */
    int deleteAppConfigById(Long id);

    List<AppConfig> selectLastVersion(String appName);

}
