package com.ximai.mes.pro.schedule;

import cn.hutool.core.bean.BeanUtil;
import com.ximai.mes.md.vo.MdWorkunitVo;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Data
public class Equipment extends Resource{
    public Equipment(){}
    public Equipment(Long id){
        super.setId(id);
    }
    private String workUnitCode;
    private String workUnitName;
    private Long workCenterId;
    private String workCenterCode;
    private String workCenterName;
    private Integer serial;
    /**
     * 固化时间
     */
    private int curingTime=0;
    /**
     * 转间时间
     */
    private int transferShopTime=0;

    private List<Task> scheduleTask=new ArrayList<Task>();//已排任务

    //设备功能点
    private EquipmentFunction equipmentFunction=new EquipmentFunction();
    //设备属性
    private EquipmentAttribute equipmentAttribute=new EquipmentAttribute();

    /**
     * 设备功能点
     */
    @Data
    public static class EquipmentFunction{

        /** 封切机开边 */
        @ApiModelProperty("封切机开边")
        private String sacmForEdgeOpening;

        /** 封切机粘贴复合 */
        @ApiModelProperty("封切机粘贴复合")
        private String sacmForPasteComposite;

        /** 封切机热复合 */
        @ApiModelProperty("封切机热复合")
        private String sacmForThermalComposite;

        /** 封切机贴标 */
        @ApiModelProperty("封切机贴标")
        private String sacmForLabeling;

        /** 封切机装扣 */
        @ApiModelProperty("封切机装扣")
        private String sacmForBuckleUp;

        /** 封切机压痕 */
        @ApiModelProperty("封切机压痕")
        private String sacmForCreasing;

        /** 封切机风琴 */
        @ApiModelProperty("封切机风琴")
        private String sacmForOrgan;

        /** 封切机热切 */
        @ApiModelProperty("封切机热切")
        private String sacmForThermalCutting;

        /** 封切机热自合 */
        @ApiModelProperty("封切机热自合")
        private String sacmForThermalSelfFusion;

        /** 封切机压齿 */
        @ApiModelProperty("封切机压齿")
        private String sacmForMolarTooth;

        /** 封切机分切 */
        @ApiModelProperty("封切机分切")
        private String sacmForSlitting;
    }

    /**
     * 设备属性
     */
    @Data
    public static class EquipmentAttribute{

        /** 加工处理最小厚度 */
        @ApiModelProperty("加工处理最小厚度")
        private BigDecimal treatingThicknessMin;

        /** 加工处理最大厚度 */
        @ApiModelProperty("加工处理最大厚度")
        private BigDecimal treatingThicknessMax;

        /** 加工处理最小宽度 */
        @ApiModelProperty("加工处理最小宽度")
        private BigDecimal treatingWidthMin;

        /** 加工处理最大宽度 */
        @ApiModelProperty("加工处理最大宽度")
        private BigDecimal treatingWidthMax;


        /** 凹印_胶版油槽数 */
        @ApiModelProperty("凹印_胶版油槽数")
        private BigDecimal dieSunkOffsetOilTankNum;

        /** 印刷方式 */
        @ApiModelProperty("印刷方式")
        private String printingMethod;
    }

    public void initEquipmentAttribute(MdWorkunitVo workUnit){
        BeanUtil.copyProperties(workUnit, this.getEquipmentAttribute());
    }
    public void initEquipmentFunction(MdWorkunitVo workUnit){
        BeanUtil.copyProperties(workUnit, this.getEquipmentFunction());
    }
    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        Equipment resource = (Equipment) o;
        return Objects.equals(super.getId(), resource.getId());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.getId());
    }
}
