package com.ximai.mes.pro.mapper.prototypeMake;

import java.util.List;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMakeProcessItem;

/**
 * 样品制作工序物料Mapper接口
 *
 * @author yinjinlu
 * @date 2024-01-20
 */
public interface ProPrototypeMakeProcessItemMapper
{
    /**
     * 查询样品制作工序物料
     *
     * @param prototypeMakeProcessItemId 样品制作工序物料主键
     * @return 样品制作工序物料
     */
    public ProPrototypeMakeProcessItem selectProPrototypeMakeProcessItemByPrototypeMakeProcessItemId(Long prototypeMakeProcessItemId);

    /**
     * 查询样品制作工序物料列表
     *
     * @param proPrototypeMakeProcessItem 样品制作工序物料
     * @return 样品制作工序物料集合
     */
    public List<ProPrototypeMakeProcessItem> selectProPrototypeMakeProcessItemList(ProPrototypeMakeProcessItem proPrototypeMakeProcessItem);

    /**
     * 新增样品制作工序物料
     *
     * @param proPrototypeMakeProcessItem 样品制作工序物料
     * @return 结果
     */
    public int insertProPrototypeMakeProcessItem(ProPrototypeMakeProcessItem proPrototypeMakeProcessItem);

    /**
     * 修改样品制作工序物料
     *
     * @param proPrototypeMakeProcessItem 样品制作工序物料
     * @return 结果
     */
    public int updateProPrototypeMakeProcessItem(ProPrototypeMakeProcessItem proPrototypeMakeProcessItem);

    /**
     * 删除样品制作工序物料
     *
     * @param prototypeMakeProcessItemId 样品制作工序物料主键
     * @return 结果
     */
    public int deleteProPrototypeMakeProcessItemByPrototypeMakeProcessItemId(Long prototypeMakeProcessItemId);

    /**
     * 批量删除样品制作工序物料
     *
     * @param prototypeMakeProcessItemIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProPrototypeMakeProcessItemByPrototypeMakeProcessItemIds(Long[] prototypeMakeProcessItemIds);

    List<ProPrototypeMakeProcessItem> selectProPrototypeMakeProcessItemByPrototypeMakeProcessId(Long prototypeMakeProcessId);

}
