package com.ximai.mes.pro.mapper;

import java.util.List;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.ProStorageDetailRecord;
import com.ximai.mes.pro.dto.ProStorageDetailRecordDto;
import org.apache.ibatis.annotations.Param;

/**
 * 入库明细记录Mapper接口
 *
 * @author generator
 * @date 2025-10-12
 */
public interface ProStorageDetailRecordMapper extends BaseMapper<ProStorageDetailRecord>
{
    /**
     * 查询入库明细记录
     *
     * @param recordId 入库明细记录主键
     * @return 入库明细记录
     */
    public ProStorageDetailRecordDto selectProStorageDetailRecordByRecordId(Long recordId);

    /**
     * 查询入库明细记录列表
     *
     * @param proStorageDetailRecord 入库明细记录
     * @return 入库明细记录集合
     */
    public List<ProStorageDetailRecordDto> selectProStorageDetailRecordList(ProStorageDetailRecord proStorageDetailRecord);

    /**
     * 新增入库明细记录
     *
     * @param proStorageDetailRecord 入库明细记录
     * @return 结果
     */
    public int insertProStorageDetailRecord(ProStorageDetailRecord proStorageDetailRecord);

    /**
     * 修改入库明细记录
     *
     * @param proStorageDetailRecord 入库明细记录
     * @return 结果
     */
    public int updateProStorageDetailRecord(ProStorageDetailRecord proStorageDetailRecord);

    /**
     * 删除入库明细记录
     *
     * @param recordId 入库明细记录主键
     * @return 结果
     */
    public int deleteProStorageDetailRecordByRecordId(Long recordId);

    /**
     * 批量删除入库明细记录
     *
     * @param recordIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProStorageDetailRecordByRecordIds(Long[] recordIds);

    /**
     * 根据箱码查询入库明细记录列表
     *
     * @param boxCode 箱码
     * @return 入库明细记录集合
     */
    public List<ProStorageDetailRecordDto> selectProStorageDetailRecordByBoxCode(@Param("boxCode") String boxCode);
}

