package com.ximai.mes.pro.mapper;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.ProRecoilMaterial;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;

/**
 * 反冲料登记Mapper接口
 *
 * @author generator
 * @date 2024-02-22
 */
public interface ProRecoilMaterialMapper extends BaseMapper<ProRecoilMaterial> {
    /**
     * 查询反冲料登记
     *
     * @param recoilMaterialId 反冲料登记主键
     * @return 反冲料登记
     */
    ProRecoilMaterial selectProRecoilMaterialById(Long recoilMaterialId);

    /**
     * 查询反冲料登记列表
     *
     * @param proRecoilMaterial 反冲料登记
     * @return 反冲料登记集合
     */
    List<ProRecoilMaterial> selectProRecoilMaterialList(ProRecoilMaterial proRecoilMaterial);

    /**
     * 新增反冲料登记
     *
     * @param proRecoilMaterial 反冲料登记
     * @return 结果
     */
    int insertProRecoilMaterial(ProRecoilMaterial proRecoilMaterial);

    /**
     * 修改反冲料登记
     *
     * @param proRecoilMaterial 反冲料登记
     * @return 结果
     */
    int updateProRecoilMaterial(ProRecoilMaterial proRecoilMaterial);

    /**
     * 删除反冲料登记
     *
     * @param recoilMaterialId 反冲料登记主键
     * @return 结果
     */

    int deleteProRecoilMaterialById(Long recoilMaterialId);

    /**
     * 批量删除反冲料登记
     *
     * @param recoilMaterialIds 需要删除的数据主键集合
     * @return 结果
     */
    int deleteProRecoilMaterialByIds(Long[] recoilMaterialIds);

    @Select(value = "select  t1.*,t2.item_id,t2.item_code,t2.item_name,t2.specification,t2.item_type_name,t2.unit_of_measure from pro_recoil_material t1 left join md_item t2 on t1.item_id = t2.item_id\n" +
            "${ew.customSqlSegment}")
    List<ProRecoilMaterial> selectListByQw(@Param("ew") QueryWrapper<ProRecoilMaterial> query);

}
