package com.ximai.mes.pro.mapper;

import java.util.List;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.ximai.mes.pro.domain.ProProductQrcodeRule;
import com.ximai.mes.pro.dto.ProProductQrcodeRuleDto;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;

/**
 * 产品二维码规则Mapper接口
 *
 * @author generator
 * @date 2024-08-31
 */
public interface ProProductQrcodeRuleMapper extends BaseMapper<ProProductQrcodeRule>
{
    /**
     * 查询产品二维码规则
     *
     * @param ruleId 产品二维码规则主键
     * @return 产品二维码规则
     */
    public ProProductQrcodeRuleDto selectProProductQrcodeRuleByRuleId(Long ruleId);

    /**
     * 查询产品二维码规则列表
     *
     * @param proProductQrcodeRule 产品二维码规则
     * @return 产品二维码规则集合
     */
    public List<ProProductQrcodeRuleDto> selectProProductQrcodeRuleList(ProProductQrcodeRule proProductQrcodeRule);

    /**
     * 查询产品二维码规则列表
     *
     * @param proProductQrcodeRuleQuery 产品二维码规则
     * @return 产品二维码规则集合
     */
    @Select("select m.*,item.item_name from pro_product_qrcode_rule m left join md_item item on m.item_id = item.item_id ${ew.customSqlSegment}")
    public List<ProProductQrcodeRuleDto> selectDtoListByQw(@Param("ew") QueryWrapper<ProProductQrcodeRule> proProductQrcodeRuleQuery);

    /**
     * 新增产品二维码规则
     *
     * @param proProductQrcodeRule 产品二维码规则
     * @return 结果
     */
    public int insertProProductQrcodeRule(ProProductQrcodeRule proProductQrcodeRule);

    /**
     * 修改产品二维码规则
     *
     * @param proProductQrcodeRule 产品二维码规则
     * @return 结果
     */
    public int updateProProductQrcodeRule(ProProductQrcodeRule proProductQrcodeRule);

    /**
     * 删除产品二维码规则
     *
     * @param ruleId 产品二维码规则主键
     * @return 结果
     */
    public int deleteProProductQrcodeRuleByRuleId(Long ruleId);

    /**
     * 批量删除产品二维码规则
     *
     * @param ruleIds 需要删除的数据主键集合
     * @return 结果
     */
    public int deleteProProductQrcodeRuleByRuleIds(Long[] ruleIds);
}
