package com.ximai.mes.pro.dto;

import io.swagger.annotations.ApiModelProperty;
import com.baomidou.mybatisplus.annotation.TableId;
import lombok.Data;
import java.util.Date;
import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 产品二维码规则对象 pro_product_qrcode_rule
 *
 * @author generator
 * @date 2024-08-31
 */
@Data
public class ProProductQrcodeRuleQuery {
    private static final long serialVersionUID = 1L;

    /** ID */
    @ApiModelProperty("ID")
    @TableId
    private Long ruleId;

    /** 产品ID */
    @ApiModelProperty("产品ID")
    private Long itemId;

    /** 产品编码 */
    @ApiModelProperty("产品编码")
    private String itemCode;

    /** 编码前缀 */
    @ApiModelProperty("编码前缀")
    private String prefix;

    /** 编码时间格式化 */
    @ApiModelProperty("编码时间格式化")
    private String datePattern;

    /** 编码流水长度 */
    @ApiModelProperty("编码流水长度")
    private Integer serialLen;

    /** 产品描述 */
    @ApiModelProperty("产品描述")
    private String itemDesc;

    /** 客户编码 */
    @ApiModelProperty("客户编码")
    private String clientCode;

    /** 客户名称 */
    @ApiModelProperty("客户名称")
    private String clientName;

    /** 当前流水 */
    @ApiModelProperty("当前流水")
    private Integer currentSerial;

    /** 创建者 */
    @ApiModelProperty("创建者")
    private String createBy;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("创建时间")
    private Date createTime;

    /** 更新者 */
    @ApiModelProperty("更新者")
    private String updateBy;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @ApiModelProperty("更新时间")
    private Date updateTime;

    private String itemName;

}
