package com.ximai.mes.pro.domain.vo;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import lombok.Data;
import lombok.ToString;

import java.math.BigDecimal;
import java.util.Date;

@Data
@ToString
public class ProWorkstationMaterialVo extends BaseEntity {

    private static final long serialVersionUID = 1L;

    /** 主建id */
    @TableId
    private Long workstationMaterialId;

    /** 申请号 */
    @Excel(name = "申请号")
    private String applyNo;

    /** 产品ID */
    @Excel(name = "产品ID")
    private Long itemId;

    /** 任务ID */
    @Excel(name = "任务ID")
    private Long taskId;

    @TableField(exist = false)
    private String taskCode;

    /** 派工记录ID */
    @Excel(name = "派工记录ID")
    private Long taskWorkunitId;

    /** 申请类型 */
    @Excel(name = "申请类型")
    private Long applyType;

    /** 申请数量 */
    @Excel(name = "申请数量")
    private BigDecimal applyNum;

    /** 领料类型 */
    @Excel(name = "领料类型")
    private Long materialType;


    /** 物料编码*/
    private String sapItemCode;

    /** 物料名称*/
    private String itemName;

    /** 领料原因 */
    @Excel(name = "领料原因")
    private String pickingReason;



    /** 工作中心ID */
    @Excel(name = "工作中心ID")
    private String workstationId;

    /** 工作中心编码 */
    @Excel(name = "工作中心编码")
    private String workstationCode;

    /** 工作中心名称 */
    @Excel(name = "工作中心名称")
    private String workstationName;

    /** 是否结案 */
    @Excel(name = "是否结案")
    private String windCase;

    /** 已发放数量 */
    @Excel(name = "已发放数量")
    private BigDecimal grantNum;

    /** 备注 */
    @Excel(name = "备注")
    private String remak;

    /** 预留字段1 */
    @Excel(name = "预留字段1")
    private String attr1;

    /** 预留字段2 */
    @Excel(name = "预留字段2")
    private String attr2;

    /** 预留字段3 */
    @Excel(name = "预留字段3")
    private Long attr3;

    /** 预留字段4 */
    @Excel(name = "预留字段4")
    private Long attr4;

    /** 工作单元id */
    @Excel(name = "工作单元id")
    private Long workunitId;

    /** 工作单元名称 */
    @Excel(name = "工作单元名称")
    private String workunitName;

    /** 工作单元编码 */
    @Excel(name = "工作单元编码")
    private String workunitCode;

    /** 需求日期 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "需求日期", width = 30, dateFormat = "yyyy-MM-dd")
    private Date startTime;

    /** 结束时间 */
    @JsonFormat(pattern = "yyyy-MM-dd")
    @Excel(name = "结束时间", width = 30, dateFormat = "yyyy-MM-dd")
    private Date endTime;


    /**
     * 编排单号
     */
    @Excel(name = "编排单号")
    private String arrangeCode;



    /** 车间编码 */
    @Excel(name = "车间编码")
    private String workshopCode;

    /** 车间名称 */
    @Excel(name = "车间名称")
    private String workshopName;

}
