package com.ximai.mes.pro.domain.to;

import com.alibaba.fastjson.annotation.JSONField;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * title: 生产版本BOM组件传SAP对象
 * author:ZHT
 * date:2024/2/20
 * description:
 */
@Data
@NoArgsConstructor
@AllArgsConstructor
@JsonIgnoreProperties
public class ProProductionSolutionBomItemTo implements Serializable {
    private static final long serialVersionUID = 1L;

    /**
     * 序号
     * 0010顺序号
     */
    @JSONField(name = "POSNR", ordinal = 0)
    private String  idx;

    /**
     * 项目类别（物料单）(可选)
     * 默认L
     */
    @JSONField(name = "POSTP", ordinal = 1)
    private char itemClass;

    /**
     * bOM组件
     * sap物料编码
     */
    @JSONField(name = "IDNRK", ordinal = 2)
    private String sapItemCode;

    /**
     * 物料描述(可选)
     */
    @JSONField(name = "IMAKT", ordinal = 3)
    private String remark;

    /**
     * 计量单位
     */
    @JSONField(name = "MEINS", ordinal = 4)
    private String unitOfMeasure;

    /**
     * 数量
     */
    @JSONField(name = "MENGE", ordinal = 5)
    private BigDecimal quantity;

    /**
     * 与成本核算相关的标识符(可选)
     * 默认X
     */
    @JSONField(name = "SANKA", ordinal = 6)
    private char costAccountingMarking;

    /**
     * 报废百分比
     */
    @JSONField(name = "AUSCH", ordinal = 7)
    private BigDecimal scrapPercentage;

    /**
     * 特殊获取(可选)
     * 虚拟件：50
     * 跨工厂发料：70
     */
    @JSONField(name = "ITSOB", ordinal = 8)
    private char specialAccess;

    /**
     * 物料供应标识
     * 例如：CPC 组件为客供，则为K；
     */
    @JSONField(name = "BEIKZ", ordinal = 9)
    private char itemSupplyMarking;

    /**
     * 替代组(可选)
     */
    @JSONField(name = "ALPGR", ordinal = 10)
    private String  alternativeGroup;

    /**
     * 替代优先级(可选)
     */
    @JSONField(name = "ALPRF", ordinal = 11)
    private BigDecimal alternativePriorities;

    /**
     * 策略(可选)
     */
    @JSONField(name = "ALPST", ordinal = 12)
    private int alternativeStrategy;

    /**
     * 使用概率(可选)
     */
    @JSONField(name = "EWAHR", ordinal = 13)
    private int alternativeProbability;

    /**
     * BOM行备注(可选)
     */
    @JSONField(name = "POTX1", ordinal = 14)
    private String bomItemRemark;

    /**
     * 物料备注(可选)
     */
    @JSONField(name = "POTX2", ordinal = 15)
    private String itemRemark;

    /**
     * 是否固定数量
     */
    @JSONField(name = "FMENG", ordinal = 16)
    private char isFixed;
}
