package com.ximai.mes.pro.domain.task;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 任务工作单元对象 pro_task_workunit
 *
 * @author zht
 * @date 2024-01-23
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProTaskWorkunit extends BaseEntity {
    private static final long serialVersionUID = 1L;
    
    @TableId
    @ApiModelProperty("生产任务ID")
    private Long taskWorkunitId;
    @ApiModelProperty("被拆分的生产任务ID")
    private Long sourceTaskWorkunitId;
    /**
     * 任务ID
     */
    @Excel(name = "任务ID")
    private Long taskId;

    @TableField(exist = false)
    private List<Long> taskIds;

    @TableField(exist = false)
    private String taskWorkunitCode;

    @TableField(exist = false)
    private Long duration;
    /**
     * 顺序号
     */
    @Excel(name = "顺序号")
    private Long idx;

    /**
     * 工作单元ID
     */
    @Excel(name = "工作单元ID")
    @ApiModelProperty("工作单元ID")
    private Long workunitId;


    private Long sourceTaskWorkunidId;
    /**
     * 单位
     */
    @Excel(name = "单位")
    private String unitOfMeasure;

    /**
     * 排产数量
     */
    @Excel(name = "排产数量")
    @ApiModelProperty("排产数量")
    private BigDecimal quantity;

    /**
     * 已生产数量
     */
    @Excel(name = "已生产数量")
    @ApiModelProperty("已生产数量")
    private BigDecimal quantityProduced;

    /**
     * 合格品数量
     */
    @Excel(name = "合格品数量")
    private BigDecimal quantityQualify;

    /**
     * 不良品数量
     */
    @Excel(name = "不良品数量")
    private BigDecimal quantityUnqualify;

    /**
     * 调整数量
     */
    @Excel(name = "调整数量")
    private BigDecimal quantityChanged;

    /**
     * 生产任务状态
     */
    @ApiModelProperty("状态")
    private String status;

    private Integer taskType;
    /**
     * 预计开始时间
     */
    @ApiModelProperty("计划开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @Excel(name = "计划开始时间")

    private Date scheduleStartDate;

    /**
     * 预计结束时间
     */
    @ApiModelProperty("计划结束时间")
    @Excel(name = "计划结束时间")

    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date scheduleEndDate;

    @ApiModelProperty("实际开始时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date actualStartDate;

    @ApiModelProperty("实际结束时间")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date actualEndDate;

    @ApiModelProperty("备注")
    private String remark;

    @TableField(exist = false)
    private Long processId;

    @ApiModelProperty("工序名")
    @TableField(exist = false)
    @Excel(name = "工序名")

    private String processName;

    @TableField(exist = false)
    @ApiModelProperty("作业单元编码")
    @Excel(name = "作业单元编码")
    private String workunitCode;

    @TableField(exist = false)
    @ApiModelProperty("作业单元名称")
    @Excel(name = "作业单元名称")
    private String workunitName;

    @TableField(exist = false)
    @ApiModelProperty("任务编码")
    @Excel(name = "任务编码")

    private String taskCode;
//
//    @TableField(exist = false)
//    private int lastAssistProcess;

    @TableField(exist = false)
    @ApiModelProperty("产品物料编码")
    @Excel(name = "产品物料编码")
    private String itemCode;

    @TableField(exist = false)
    @ApiModelProperty("产品物料名称")
    @Excel(name = "产品物料名称")
    private String itemName;

    @TableField(exist = false)
    @ApiModelProperty("规格型号")
    @Excel(name = "规格型号")
    private String specification;

    @TableField(exist = false)
    @ApiModelProperty("工作中心名称")
    @Excel(name = "工作中心名称")
    private String workstationName;

    @ApiModelProperty("工作中心ID")
    @Excel(name = "工作中心ID")
    private Long workstationId;

    @ApiModelProperty("工作中心ID")
    @Excel(name = "工作中心ID")
    private String workstationCode;

    @ApiModelProperty("外包单价")
    private BigDecimal outsourceUnitPrice;

    @ApiModelProperty("是否委外,1:是，0:否")
    private Integer outsourced;

    @ApiModelProperty("供应商ID")
    private Long vendorId;

    @ApiModelProperty("供应商名称")
    private String vendorName;

    @TableField(exist = false)
    @ApiModelProperty("编排单号")
    private String arrangeCode;

    @TableField(exist = false)
    @ApiModelProperty("工单编号")
    @Excel(name = "工单编号")
    private String workorderCode;

    @TableField(exist = false)
    @ApiModelProperty("待生产数量")
    @Excel(name = "可加工数量")
    private BigDecimal quantityWait;

    private int percent;
    @ApiModelProperty("客户图号")
    @TableField(exist = false)
    @Excel(name = "产品图号")
    private String customerDrawingNo;


    @ApiModelProperty("订单单号")
    @Excel(name = "订单单号")
    private String orderCode;
    @ApiModelProperty("项目号")
    @Excel(name = "项目号")
    private String customerProjectNo;
    @ApiModelProperty("任务批号")
    @Excel(name = "排产次数")
    private String taskBatch;

    @ApiModelProperty("标准工时")
    private BigDecimal stdWorkingTime;

    @ApiModelProperty("工时单位")
    private String stdWorkingTimeUom;

    @ApiModelProperty("单价")
    private BigDecimal unitPrice;
}
