package com.ximai.mes.pro.domain.proWorkOrder;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.ximai.common.annotation.Excel;
import com.ximai.common.core.domain.BaseEntity;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.math.BigDecimal;

/**
 * 工单工序工装夹具关联 pro_work_order_process_tool
 *
 * @author zht
 * @date 2024-01-28
 */
@Data
@AllArgsConstructor
@NoArgsConstructor
public class ProWorkOrderProcessTool extends BaseEntity {
    private static final long serialVersionUID = 1L;

    /**
     * id
     */
    @TableId
    private Long workorderProcessToolId;

    /**
     * 生产工单工序ID
     */
    @Excel(name = "生产工单工序ID")
    private Long workorderProcessId;

    private Long workOrderId;

    /**
     * 工装夹具ID，关联物料基础表
     */
    @Excel(name = "工装夹具ID")
    private Long toolId;

    /**
     * 要求数量
     */
    @Excel(name = "要求数量")
    private BigDecimal quantity;


    /**
     * 工装夹具编码
     */
    @TableField(exist = false)
    private String itemCode;

    /**
     * 工装夹具名称
     */
    private String itemName;

    private String sapItemCode;

    /**
     * 型号
     */
    @TableField(exist = false)
    private String specification;

    /**
     * 工装夹具类型编码
     */
    @TableField(exist = false)
    private String itemTypeName;

}
