package com.ximai.mes.pro.controller.prototypeMake;

import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.prototypeMake.ProPrototypeMakeProcessItem;
import com.ximai.mes.pro.service.prototypeMake.IProPrototypeMakeProcessItemService;
import com.ximai.common.core.page.TableDataInfo;

/**
 * 样品制作工序物料Controller
 *
 * @author yinjinlu
 * @date 2024-01-20
 */
@RestController
@RequestMapping("/mes/pro/prototypeMakeProcessItem")
public class ProPrototypeMakeProcessItemController extends BaseController
{
    @Autowired
    private IProPrototypeMakeProcessItemService proPrototypeMakeProcessItemService;

    /**
     * 查询样品制作工序物料列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeMakeProcessItem:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProPrototypeMakeProcessItem proPrototypeMakeProcessItem)
    {
        startPage();
        List<ProPrototypeMakeProcessItem> list = proPrototypeMakeProcessItemService.selectProPrototypeMakeProcessItemList(proPrototypeMakeProcessItem);
        return getDataTable(list);
    }


    /**
     * 获取样品制作工序物料详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeMakeProcessItem:query')")
    @GetMapping(value = "/{prototypeMakeProcessItemId}")
    public AjaxResult getInfo(@PathVariable("prototypeMakeProcessItemId") Long prototypeMakeProcessItemId)
    {
        return AjaxResult.success(proPrototypeMakeProcessItemService.selectProPrototypeMakeProcessItemByPrototypeMakeProcessItemId(prototypeMakeProcessItemId));
    }

    /**
     * 新增样品制作工序物料
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeMakeProcessItem:add')")
    @Log(title = "样品制作工序物料", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProPrototypeMakeProcessItem proPrototypeMakeProcessItem)
    {
        return toAjax(proPrototypeMakeProcessItemService.insertProPrototypeMakeProcessItem(proPrototypeMakeProcessItem));
    }

    /**
     * 修改样品制作工序物料
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeMakeProcessItem:edit')")
    @Log(title = "样品制作工序物料", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProPrototypeMakeProcessItem proPrototypeMakeProcessItem)
    {
        return toAjax(proPrototypeMakeProcessItemService.updateProPrototypeMakeProcessItem(proPrototypeMakeProcessItem));
    }

    /**
     * 删除样品制作工序物料
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:prototypeMakeProcessItem:remove')")
    @Log(title = "样品制作工序物料", businessType = BusinessType.DELETE)
	@DeleteMapping("/{prototypeMakeProcessItemIds}")
    public AjaxResult remove(@PathVariable Long[] prototypeMakeProcessItemIds)
    {
        return toAjax(proPrototypeMakeProcessItemService.deleteProPrototypeMakeProcessItemByPrototypeMakeProcessItemIds(prototypeMakeProcessItemIds));
    }
}
