package com.ximai.mes.pro.controller.productionSolution;

import com.ximai.common.annotation.Log;
import com.ximai.common.core.controller.BaseController;
import com.ximai.common.core.domain.AjaxResult;
import com.ximai.common.core.page.TableDataInfo;
import com.ximai.common.enums.BusinessType;
import com.ximai.mes.pro.domain.productionSolution.ProProductionSolutionProcess;
import com.ximai.mes.pro.domain.vo.ProProductionSolutionProcessVo;
import com.ximai.mes.pro.service.productionSolution.IProProductionSolutionProcessService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 生产版本工序Controller
 *
 * @author zht
 * @date 2024-01-23
 */
@RestController
@RequestMapping("/mes/pro/productionSolutionProcess")
public class ProProductionSolutionProcessController extends BaseController {
    @Autowired
    private IProProductionSolutionProcessService proProductionSolutionProcessService;

    /**
     * 查询生产版本工序列表
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionSolutionProcess:list')")
    @GetMapping("/list")
    public TableDataInfo list(ProProductionSolutionProcess proProductionSolutionProcess) {
        startPage();
        List<ProProductionSolutionProcessVo> list = proProductionSolutionProcessService.selectProProductionSolutionProcessList(proProductionSolutionProcess);
        return getDataTable(list);
    }
//
//    /**
//     * 导出生产版本工序列表
//     */
//    @PreAuthorize("@ss.hasPermi('mes/pro:productionSolutionProcess:export')")
//    @Log(title = "生产版本工序", businessType = BusinessType.EXPORT)
//    @PostMapping("/export")
//    public void export(HttpServletResponse response, ProProductionSolutionProcess proProductionSolutionProcess) {
//        List<ProProductionSolutionProcessVo> list = proProductionSolutionProcessService.selectProProductionSolutionProcessList(proProductionSolutionProcess);
//        ExcelUtil<ProProductionSolutionProcessVo> util = new ExcelUtil<ProProductionSolutionProcessVo>(ProProductionSolutionProcessVo.class);
//        util.exportExcel(response, list, "生产版本工序数据");
//    }

    /**
     * 获取生产版本工序详细信息
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionSolutionProcess:query')")
    @GetMapping(value = "/{productionSolutionProcessId}")
    public AjaxResult getInfo(@PathVariable("productionSolutionProcessId") Long productionSolutionProcessId) {
        return AjaxResult.success(proProductionSolutionProcessService.selectProProductionSolutionProcessByProductionSolutionProcessId(productionSolutionProcessId));
    }

    /**
     * 新增生产版本工序
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionSolutionProcess:add')")
    @Log(title = "生产版本工序", businessType = BusinessType.INSERT)
    @PostMapping
    public AjaxResult add(@RequestBody ProProductionSolutionProcess proProductionSolutionProcess) {
        return toAjax(proProductionSolutionProcessService.insertProProductionSolutionProcess(proProductionSolutionProcess));
    }

    /**
     * 修改生产版本工序
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionSolutionProcess:edit')")
    @Log(title = "生产版本工序", businessType = BusinessType.UPDATE)
    @PutMapping
    public AjaxResult edit(@RequestBody ProProductionSolutionProcess proProductionSolutionProcess) {
        return toAjax(proProductionSolutionProcessService.updateProProductionSolutionProcess(proProductionSolutionProcess));
    }

    /**
     * 删除生产版本工序
     */
    @PreAuthorize("@ss.hasPermi('mes/pro:productionSolutionProcess:remove')")
    @Log(title = "生产版本工序", businessType = BusinessType.DELETE)
    @DeleteMapping("/{productionSolutionProcessIds}")
    public AjaxResult remove(@PathVariable Long[] productionSolutionProcessIds) {
        return toAjax(proProductionSolutionProcessService.deleteProProductionSolutionProcessByProductionSolutionProcessIds(productionSolutionProcessIds));
    }
}
