package com.ximai.mes.od.service.impl;

import cn.hutool.core.map.MapUtil;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ximai.mes.od.domain.OdSalesOrderDetailItem;
import com.ximai.mes.od.mapper.OdSalesOrderDetailItemMapper;
import com.ximai.mes.od.service.IOdSalesOrderDetailItemService;
import lombok.AllArgsConstructor;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.Map;

/**
 * 【请填写功能名称】Service业务层处理
 *
 * @author generator
 * @date 2024-02-18
 */
@Service
@AllArgsConstructor
public class OdSalesOrderDetailItemServiceImpl extends ServiceImpl<OdSalesOrderDetailItemMapper, OdSalesOrderDetailItem> implements IOdSalesOrderDetailItemService {


    @Override
    public IPage<OdSalesOrderDetailItem> page(Map<String, Object> params) {
        final Integer pageNum = MapUtil.getInt(params, "pageNum");
        final Integer pageSize = MapUtil.getInt(params, "pageSize");
        return page(new Page<>(pageNum, pageSize));
    }

    @Override
    public OdSalesOrderDetailItem selectById(Long id) {
        return getById(id);
    }

    @Override
    public List<OdSalesOrderDetailItem> selectList(OdSalesOrderDetailItem odSalesOrderDetailItem) {
        return list();
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean insert(OdSalesOrderDetailItem odSalesOrderDetailItem) {
        return save(odSalesOrderDetailItem);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean update(OdSalesOrderDetailItem odSalesOrderDetailItem) {
        return updateById(odSalesOrderDetailItem);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean deleteByIds(List<Long> ids) {
        return removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public Boolean deleteById(Long id) {
        return removeById(id);
    }

}
