package com.ximai.mes.md.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ximai.common.constant.UserConstants;
import com.ximai.common.utils.MessageUtils;
import com.ximai.common.utils.data.DateUtils;
import com.ximai.common.utils.data.ExceptionUtil;
import com.ximai.common.utils.data.StringUtils;
import com.ximai.mes.md.domain.MdWorkstationWorker;
import com.ximai.mes.md.domain.MdWorkunit;
import com.ximai.mes.md.mapper.MdWorkstationWorkerMapper;
import com.ximai.mes.md.mapper.MdWorkunitMapper;
import com.ximai.mes.md.service.IMdWorkstationWorkerService;
import org.checkerframework.checker.units.qual.A;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * 人力资源Service业务层处理
 *
 * @date 2022-05-12
 */
@Service
public class MdWorkstationWorkerServiceImpl implements IMdWorkstationWorkerService {
    @Autowired
    private MdWorkstationWorkerMapper mdWorkstationWorkerMapper;

    @Autowired
    private MdWorkunitMapper mdWorkunitMapper;

    /**
     * 查询人力资源
     *
     * @param recordId 人力资源主键
     * @return 人力资源
     */
    @Override
    public MdWorkstationWorker selectMdWorkstationWorkerByRecordId(Long recordId) {
        return mdWorkstationWorkerMapper.selectMdWorkstationWorkerByRecordId(recordId);
    }

    /**
     * 查询人力资源列表
     *
     * @param mdWorkstationWorker 人力资源
     * @return 人力资源
     */
    @Override
    public List<MdWorkstationWorker> selectMdWorkstationWorkerList(MdWorkstationWorker mdWorkstationWorker) {
        return mdWorkstationWorkerMapper.selectMdWorkstationWorkerList(mdWorkstationWorker);
    }

    @Override
    public String checkPostExist(MdWorkstationWorker mdWorkstationWorker) {
        MdWorkstationWorker post = mdWorkstationWorkerMapper.checkPostExist(mdWorkstationWorker);
        Long recordId = mdWorkstationWorker.getRecordId() == null ? -1L : mdWorkstationWorker.getRecordId();
        if (StringUtils.isNotNull(post) && post.getRecordId().longValue() != recordId.longValue()) {
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }

    @Override
    public String checkPostExist1(MdWorkstationWorker mdWorkstationWorker) {
        MdWorkstationWorker user = mdWorkstationWorkerMapper.checkPostExist1(mdWorkstationWorker);
        Long recordId = mdWorkstationWorker.getRecordId() == null ? -1L : mdWorkstationWorker.getRecordId();
        if (StringUtils.isNotNull(user) && user.getRecordId().longValue() != recordId.longValue()) {
            return UserConstants.NOT_UNIQUE;
        }
        return UserConstants.UNIQUE;
    }

    /**
     * 新增人力资源
     *
     * @param mdWorkstationWorker 人力资源
     * @return 结果
     */
    @Override
    public int insertMdWorkstationWorker(MdWorkstationWorker mdWorkstationWorker) {
        mdWorkstationWorker.setCreateTime(DateUtils.getNowDate());
        return mdWorkstationWorkerMapper.insertMdWorkstationWorker(mdWorkstationWorker);
    }

    /**
     * 修改人力资源
     *
     * @param mdWorkstationWorker 人力资源
     * @return 结果
     */
    @Override
    public int updateMdWorkstationWorker(MdWorkstationWorker mdWorkstationWorker) {
        mdWorkstationWorker.setUpdateTime(DateUtils.getNowDate());
        return mdWorkstationWorkerMapper.updateMdWorkstationWorker(mdWorkstationWorker);
    }

    /**
     * 批量删除人力资源
     *
     * @param recordIds 需要删除的人力资源主键
     * @return 结果
     */
    @Override
    public int deleteMdWorkstationWorkerByRecordIds(Long[] recordIds) {
        return mdWorkstationWorkerMapper.deleteMdWorkstationWorkerByRecordIds(recordIds);
    }

    /**
     * 删除人力资源信息
     *
     * @param recordId 人力资源主键
     * @return 结果
     */
    @Override
    public int deleteMdWorkstationWorkerByRecordId(Long recordId) {
        return mdWorkstationWorkerMapper.deleteMdWorkstationWorkerByRecordId(recordId);
    }

    @Override
    public int deleteByWorkstationId(Long workstationId) {
        //校验数据
        QueryWrapper<MdWorkunit> query = new QueryWrapper<>();
        query.eq("t1.workstation_id",workstationId);
        ExceptionUtil.checkTrueThrowException(mdWorkunitMapper.selectListByQw(query).size() > 0, MessageUtils.message("delete.data.error.occupied"));
        return mdWorkstationWorkerMapper.deleteByWorkstationId(workstationId);
    }
}
