package com.ximai.mes.md.service.impl;

import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdSaleOrderTypeMapper;
import com.ximai.mes.md.domain.MdSaleOrderType;
import com.ximai.mes.md.service.IMdSaleOrderTypeService;

/**
 * 销售订单类型Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-22
 */
@Service
public class MdSaleOrderTypeServiceImpl implements IMdSaleOrderTypeService
{
    @Autowired
    private MdSaleOrderTypeMapper mdSaleOrderTypeMapper;

    /**
     * 查询销售订单类型
     *
     * @param id 销售订单类型主键
     * @return 销售订单类型
     */
    @Override
    public MdSaleOrderType selectMdSaleOrderTypeById(Long id)
    {
        return mdSaleOrderTypeMapper.selectMdSaleOrderTypeById(id);
    }

    /**
     * 查询销售订单类型列表
     *
     * @param mdSaleOrderType 销售订单类型
     * @return 销售订单类型
     */
    @Override
    public List<MdSaleOrderType> selectMdSaleOrderTypeList(MdSaleOrderType mdSaleOrderType)
    {
        return mdSaleOrderTypeMapper.selectMdSaleOrderTypeList(mdSaleOrderType);
    }

    /**
     * 新增销售订单类型
     *
     * @param mdSaleOrderType 销售订单类型
     * @return 结果
     */
    @Override
    public int insertMdSaleOrderType(MdSaleOrderType mdSaleOrderType)
    {
        return mdSaleOrderTypeMapper.insertMdSaleOrderType(mdSaleOrderType);
    }

    /**
     * 修改销售订单类型
     *
     * @param mdSaleOrderType 销售订单类型
     * @return 结果
     */
    @Override
    public int updateMdSaleOrderType(MdSaleOrderType mdSaleOrderType)
    {
        return mdSaleOrderTypeMapper.updateMdSaleOrderType(mdSaleOrderType);
    }

    /**
     * 批量删除销售订单类型
     *
     * @param ids 需要删除的销售订单类型主键
     * @return 结果
     */
    @Override
    public int deleteMdSaleOrderTypeByIds(Long[] ids)
    {
        return mdSaleOrderTypeMapper.deleteMdSaleOrderTypeByIds(ids);
    }

    /**
     * 删除销售订单类型信息
     *
     * @param id 销售订单类型主键
     * @return 结果
     */
    @Override
    public int deleteMdSaleOrderTypeById(Long id)
    {
        return mdSaleOrderTypeMapper.deleteMdSaleOrderTypeById(id);
    }
}
