package com.ximai.mes.md.service.impl;

import java.util.List;

import com.ximai.mes.md.vo.MdProductFactoryVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ximai.mes.md.mapper.MdProductFactoryMapper;
import com.ximai.mes.md.domain.MdProductFactory;
import com.ximai.mes.md.service.IMdProductFactoryService;

/**
 * 产品工厂配置Service业务层处理
 *
 * @author yinjinlu
 * @date 2024-01-17
 */
@Service
public class MdProductFactoryServiceImpl implements IMdProductFactoryService
{
    @Autowired
    private MdProductFactoryMapper mdProductFactoryMapper;

    /**
     * 查询产品工厂配置
     *
     * @param productFactoryId 产品工厂配置主键
     * @return 产品工厂配置
     */
    @Override
    public MdProductFactory selectMdProductFactoryByProductFactoryId(Long productFactoryId)
    {
        return mdProductFactoryMapper.selectMdProductFactoryByProductFactoryId(productFactoryId);
    }

    /**
     * 查询产品工厂配置列表
     *
     * @param mdProductFactory 产品工厂配置
     * @return 产品工厂配置
     */
    @Override
    public List<MdProductFactoryVo> selectMdProductFactoryList(MdProductFactory mdProductFactory)
    {
        return mdProductFactoryMapper.selectMdProductFactoryList(mdProductFactory);
    }

    /**
     * 新增产品工厂配置
     *
     * @param mdProductFactory 产品工厂配置
     * @return 结果
     */
    @Override
    public int insertMdProductFactory(MdProductFactory mdProductFactory)
    {
        return mdProductFactoryMapper.insertMdProductFactory(mdProductFactory);
    }

    /**
     * 修改产品工厂配置
     *
     * @param mdProductFactory 产品工厂配置
     * @return 结果
     */
    @Override
    public int updateMdProductFactory(MdProductFactory mdProductFactory)
    {
        return mdProductFactoryMapper.updateMdProductFactory(mdProductFactory);
    }

    /**
     * 批量删除产品工厂配置
     *
     * @param productFactoryIds 需要删除的产品工厂配置主键
     * @return 结果
     */
    @Override
    public int deleteMdProductFactoryByProductFactoryIds(Long[] productFactoryIds)
    {
        return mdProductFactoryMapper.deleteMdProductFactoryByProductFactoryIds(productFactoryIds);
    }

    /**
     * 删除产品工厂配置信息
     *
     * @param productFactoryId 产品工厂配置主键
     * @return 结果
     */
    @Override
    public int deleteMdProductFactoryByProductFactoryId(Long productFactoryId)
    {
        return mdProductFactoryMapper.deleteMdProductFactoryByProductFactoryId(productFactoryId);
    }
}
